The first step in mathematically tackling a practical decision-making problem consists of formulating a suitable mathematical model of a system or situation. If we intend to make reasonably adequate mathematical models of situations that help practicing decision makers in searching for rational decisions, we should be able to introduce fuzziness into our models and to suggest means of processing fuzzy information. 

In this paper a methodology to solve an FLP problem by using a logistic membership function is considered. The rest of the paper is organized as follows. In section 2, the basic fuzzy model is defined and this is followed by a numerical example in section 3. Section 4 provides the results and discussion, and finally, concluding remarks are made in section 5. 

## Ii. The Model

A conventional linear programming problem is defined by 

$${\mathrm{Subject~to}}\quad A x\leq b,\quad x\geq0.$$
Maximize
Cx
 (1) 
in which the components of a 1×n vector C, an m×n matrix A
and an n×1 vector b are all crisp parameters and x is an ndimensional decision variable vector. 

The system (1) may be redefined in a fuzzy environment with the following more elaborate structure: 

$${\mathrm{Maximize~}}\sum_{j=1}^{n}{\tilde{c}}_{j}x_{j}$$
n
Subject to 

$$\sum_{j=1}^{n}\widetilde{a}_{ij}x_{j}\leq b_{i},\quad i=1,2\cdots m$$

All fuzzy data ),( ~ ~ bj ajj ≡ *ccSc* and ),( ~ ~ bij aijij ≡ *aaSa* are fuzzy variables with the following logistic membership functions [13], 

![0_image_1.png](0_image_1.png)

⎪ ⎪ ≤ ⎪ ⎪ = ≤ ⎨ ≤ ⎪ ⎪+ ⎪ ⎪ ≥ ⎩ a j j 1 if c c B if c c c a b c j j j % (3)  if c c α μ − − ⎛ ⎞ ⎜ ⎟ ⎜ ⎟ ⎝ ⎠ j a c c j j b a c c j j 1 Ce b j j 0

![0_image_0.png](0_image_0.png)

a b if a a a ij ij if a a B if aaa b ij ij

% (4) 

## Iii. Numerical Example

$$(1)$$

In this example the profit for a unit of sheet sales is around 1.05 Euro; a unit of pillow case sales is around 0.3 Euro and a unit of quilt sales is around 1.8 Euro. The firm concerned would like to sell approximately 25.000 sheet units, 40.000 pillow case units and 10.000 units quilt units. The monthly working capacity and required process time for the production of sheets, pillow cases and quilts are given in Table 1 [14]. 

In view of this, let us determine monthly production planning details and profit for a home-textile group. X1 presents the quantity of sheets that will be produced, X2 presents the quantity of pillow cases and X3 presents the quantity of quilts. The profit figures with logistic membership functions as given in Table I. 

TABLE I. REQUIRED PROCESS TIME FOR SHEET, PILLOW CASE 
AND OF A QUILT [14] 

$$\left(2\right)$$

| Required unit time(hour)             |                             |                           |                          |                           |
|--------------------------------------|-----------------------------|---------------------------|--------------------------|---------------------------|
| Departments                          | Sheet                       | Pillow  case              | Quilt                    | Working  hours per  month |
| Cutting  Sewing  Pleating  Packaging | 0.0033  0.056  0.0067  0.01 | 0.001  0.025  0.004  0.01 | 0.0033  0.1  0.017  0.01 | 208  4368  520  780       |

If we consider, around 1.05 ≡ S(1.02,1.08) % , around 0.3 ≡ 
S(0.2,0.4) % , and around 1.8 ≡ S(1.7, 2.0) % , then, the mathematical model of the above problem with fuzzy objective coefficients can be described as follows. 

 
Maximize 

$$\mathbf{\Pi}^{(3)}$$
$S(1.02,1.08)x_{1}+S(0.2,0.4)x_{2}+S(1.7,2.0)x_{3}$
subject to 
;208 3 0033.0 2 01.0 1 033.0

$$0.0067\,x_{1}+0.04\,x_{2}+0.17\,x_{3}\leq520\,;$$
++ ≤
$$0.056\,x_{1}+0.25\,x_{2}+0.1x_{3}\leq4368\,;$$
xx x
$$0.1x_{1}+0.1x_{2}+0.01x_{3}\leq780\,;$$

(5)  $\frac{1}{2}$ . 
 (5) 
$$x_{3}\geq10000\;;$$
$$x_{2}\geq40000\;;$$
$$x_{1}\geq25000\;;$$
