The rest of paper is organized as follows. A brief introduction to the concepts related to zooming functions of a digital camera is presented in Section II. Section III describes the theoretical aspects of fuzzy system by discussing the philosophy and development of fuzzy logic, fuzzy model and proposed algorithm. Section IV provides the results and discussion and lastly, conclusions are given in section V. 

## Ii. Zoom Tracking Algorithm

In some conventional look-up table zoom tracking methods, the control circuit comprises of a microprocessor equipped with read only memory (ROM) that stores data curves for various focal distances. When the zoom lens is shifted for executing a zooming operation, the focusing lens is correspondingly shifted along the proper trace curve. Since the ROM cannot store the trace data for many distances due to limitations of its memory size, the traces between the stored traces are estimated using the following equation [16]: 

s
$$d_{c}=D_{c}\,{\frac{d_{s}}{D_{s}}}$$
d = Dd (1)
where Ds is the difference between the focus positions of the 

![0_image_0.png](0_image_0.png) upper and lower traces, and ds is difference between the focus positions of the estimated and the lower trace at the zoom start point of Fig. 1. Dc is the difference between the focus positions of the upper and the lower traces, and dc is the difference between the focus positions of the estimated and the lower trace at the current zoom point. As the zoom lens is shifted, the focusing lens tracks the trace stored or estimated. 

However, if the lens position sensors do not have sufficient resolution then accurate estimation curve traces are not acquired. This results in bad focusing. The de-focusing gradually increases as the zoom lens moves toward the teleend. For better estimation more acquired data is needed thus increasing ROM size. 

## Iii. Fuzzy Logic

A. Philosophy and Development of Fuzzy Logic Human reasoning is fuzzy, or approximate, and so is the real world. Fuzzy logic is the logic underlying modes of reasoning which are approximate rather than exact, thus it is closer to human reasoning and the real world than formal logic. Fuzzy logic was introduced by Zadeh in [17] and used by Mamdani to control the dynamic system in [18]. Since then, fuzzy logic has been successfully applied to many applications for automatic control (especially for non-linear ill-defined systems) [19-21]. The concept of fuzzy set is a class with unsharp boundaries. It provides a basis for a qualitative approach to the analysis of complex systems in which linguistic rather than numerical variables are employed to describe system behaviour and performance. Thus, in this work, fuzzy controller to incorporation of fuzzy techniques into the auto image zooming to achieve the automatic control during zooming function is proposed. 

## B. Model Description

Fuzzy logic algorithms have been widely used in many control applications. Unlike a conventional proportionalintegral-derivative (PID) controller, the FLC can achieve the goals of steady output and satisfactory transient performance simultaneously. However, choices of rule sets and membership functions significantly affect achieving these performance goals [22]. Two well-known Fuzzy rule-based Inference System are Mamdani fuzzy method and TagakiSugeno (T-S) fuzzy method [23]. Advantages of the Mamdani fuzzy inference system are it's intuitive, has widespread acceptance and well suited to human cognition [24-26]. The TS fuzzy inference system works well with linear techniques and guarantees continuity of the output surface [27-28]. But the T-S fuzzy inference system has difficulties in dealing with the multi-parameter synthetic evaluation; it has difficulties in assigning weight to each input and fuzzy rules. Mamdani model can show its legibility and understandability to the laypeople. The Mamdani fuzzy inference system shows its advantage in output expression and is used in this project. 

Fuzzy logic starts with the concept of a fuzzy set. A fuzzy set is a set without a crisp, clearly defined boundary. It can contain elements with only a partial degree of membership [28]. A fuzzy set is defined by the expression below: 

$X_{\alpha}/\mu$
$$D=\{(x,$$
$|\downarrow\rangle$
$$\left(2\right)$$

## = ∈ Xxixxxd ∈ ]}1,0[)(,))(,{( Μ D Μ D (2)

where X represents the universal set, x is an element of X, D is a fuzzy subset in X and μ*D(x)* is the membership function of fuzzy set D. 

Degree of membership for any set ranges from 0 to 1. A 
value of 1.0 represents a 100% membership while a value of 0 means 0% membership. If there are 5 subgroups of size, then 5 membership functions are required to express the size values in fuzzy rules. A membership function is a curve that defines how each point in the input space is mapped to a membership value (or degree of membership) between 0 and 1. The input space is sometimes referred to as the universe of discourse [29]. The membership functions are usually defined for input and output variables. There are some forms of membership functions such as triangular, trapezoidal, Gaussian distribution and others. In this study, triangular and trapezoidal 