

![0_image_0.png](0_image_0.png)

## 2 Design Of A Synthesiser For Specialised Constraint Solvers

The design of Dominion distinguishes two main parts. The *analyser* analyses the problem model and produces a solver specification that describes what components the specialised solver needs to have and which algorithms and data structures to use. The *generator* takes the solver specification and generates a solver that conforms to it. The flow of information is illustrated in Figure 1.

Both the analyser and the generator optimise the solver. While the analyser performs the high-level optimisations that depend on the structure of the problem model, the generator performs low-level optimisations which depend on the implementation of the solver. Those two parts are independent and linked by the solver specification, which is completely agnostic of the format of the problem model and the implementation of the specialised solver. There can be different front ends for both the analyser and the generator to handle problems specified in a variety of formats and specialise solvers in a number of different ways, e.g.

based on existing building blocks or synthesised from scratch.

## 2.1 The Analyser

The analyser operates on the model of a constraint problem class or instance. It determines the constraints, variables, and associated domains required to solve the problem and reasons about the algorithms and data structures the specialised solver should use. It makes high-level design decisions, such as whether to use trailing or copying for backtracking memory. It also decides what propagation algorithms to use for specific constraints and what level of consistency to enforce.

The output of the analyser is a solver specification that describes all the design decisions made. It does not necessarily fix all design decisions - it may use default values - if the analyser is unable to specialise a particular part of the solver for a particular problem model.