In general terms, the requirements for the solver specification are that it
(a) describes a solver which is able to find solutions to the analysed problem model and (b) describes optimisations which will make this solver perform better than a general solver.

The notion of better performance includes run time as well as other resources such as memory. It is furthermore possible to optimise with respect to a particular resource; for example a solver which uses less memory at the expense of run time for embedded systems with little memory can be specified.

The solver specification may include a representation of the original problem model such that a specialised solver which encodes the problem can be produced
- the generated solver does not require any input when run or only values for the parameters of a problem class. It may furthermore modify the original model in a limited way; for example split variables which were defined as one type into several new types. It does not, however, optimise it like for example Tailor [8].

The analyser may read a partial solver specification along with the model of the problem to be analysed to still allow fine-tuning by human experts while not requiring it. This also allows for running the analyser incrementally, refining the solver specification based on analysis and decisions made in earlier steps.

The analyser creates a constraint optimisation model of the problem of specialising a constraint solver. The decision variables are the design decisions to be made and the values in their domains are the options which are available for their implementation. The constraints encode which parts are required to solve the problem and how they interact. For example, the constraints could require the presence of an integer variable type and an equals constraint which is able to handle integer variables. A solution to this constraint problem is a solver specification that describes a solver which is able to solve the problem described in the original model. The weight attached to each solution describes the performance of the specialised solver and could be based on static measures of performance as well as dynamic ones; e.g. predefined numbers describing the performance of a specific algorithm and experimental results from probing a specific implementation.

This metamodel enables the use of constraint programming techniques for generating the specialised solver and ensures that a solver specification can be created efficiently even for large metamodels.

The result of running the analyser phase of the system is a solver specification which specifies a solver tailored to the analysed problem model.

## 2.2 The Generator

The generator reads the solver specification produced by the analyser and constructs a specialised constraint solver accordingly. It may modify an existing solver, or synthesise one from scratch. The generated solver has to conform to the solver specification, but beyond that, no restrictions are imposed. In particular, the generator does not guarantee that the generated specialised solver