will have better performance than a general solver, or indeed be able to solve constraint problems at all - this is encoded in the solver specification.

In addition to the high-level design decisions fixed in the solver specification, the generator can perform low-level optimisations which are specific to the implementation of the specialised solver. It could for example decide to represent domains with a data type of smaller range than the default one to save space.

The scope of the generator is not limited to generating the source code which implements the specialised solver, but also includes the system to build it.

The result of running the generator phase of the system is a specialised solver which conforms to the solver specification.

## 3 Preliminary Implementation And Experimental Results

We have started implementing the design proposed above in a system which operates on top of Minion [9]. The analyser reads Minion input files and writes a solver specification which describes the constraints and the variable types which are required to solve the problem. It does not currently create a metamodel of the problem. The generator modifies Minion to support only those constraints and variable types. It furthermore does some additional low-level optimisations by removing infrastructure code which is not required for the specialised solver.

The current implementation of Dominion sits between the existing Tailor and Minion projects - it takes Minion problem files, which may have been generated by Tailor, as input, and generates a specialised Minion solver.

The generated solver is specialised for models of problem instances from the problem class the analysed instance belongs to. The models have to be the same with respect to the constraints and variable types used.

Experimental results for models from four different problem classes are shown in Figure 2. The graph only compares the CPU time Minion and the specialised solver took to solve the problem; it does not take into account the overhead of running Dominion - analysing the problem model, generating the solver, and compiling it, which was in the order of a few minutes for all of the benchmarks.

The problem classes Balanced Incomplete Block Design, Golomb Ruler, nQueens, and Social Golfers were chosen because they use a range of different constraints and variable types. Hence the optimisations Dominion can perform are different for each of these problem classes. This is reflected in the experimental results by different performance improvements for different classes.

Figure 2 illustrates two key points. The first point is that even a quite basic implementation of Dominion which does only a few optimisations can yield significant performance improvements over standard Minion. The second point is that the performance improvement does not only depend on the problem class, but also on the instance, even if no additional optimisations beyond the class level were performed. For both the Balanced Incomplete Block Design and the Social Golfers problem classes the largest instances yield significantly higher improvements than smaller ones.