a certain overhead, making the approach infeasible for small and quick-to-solve problems.

## 4 Conclusion And Future Work

We have described the design of Dominion, a solver generator, and demonstrated its feasibility by providing a preliminary implementation. We have furthermore demonstrated the feasibility and effectiveness of the general approach of generating specialised constraint solvers for problem models by running experiments with Minion and Dominion-generated solvers and obtaining results which show significant performance improvements. These results do not take the overhead of running Dominion into account, but we are confident that for large problem models there will be an overall performance improvement despite the overhead.

Based on our experiences with Dominion, we propose that the next step should be the generation of specialised variable types for the model of a problem instance. Dominion will extend Minion and create variable types of the sort "Integer domain ranging from 10 to 22". This not only allows us to choose different representations for variables based on the domain, but also to simplify and speed up services provided by the variable, such as checking the bounds of the domain or checking whether a particular value is in the domain.

The implementation of specialised variable types requires generating solvers for models of problem instances because the analysed problem model is essentially rewritten. The instance the solver was specialised for will be encoded in it and no further input will be required to solve the problem. We expect this optimisation to provide an additional improvement in performance which is more consistent across different problem classes, i.e. we expect significant improvements for all problem models and not just some.

We are also planning on continuing to specify the details of Dominion and implementing it.

## 5 Acknowledgements

The authors thank Chris Jefferson for extensive help with the internals of Minion and the anonymous reviewers for their feedback. Lars Kotthof f is supported by a SICSA studentship.

## References

1. Stuckey, P.J., de la Banda, M.J.G., Maher, M.J., Marriott, K., Slaney, J.K., Somogyi, Z., Wallace, M., Walsh, T.: The G12 project: Mapping solver independent models to efficient solutions. In: ICLP 2005. 9–13 2. Minton, S.: Automatically configuring constraint satisfaction programs: A case study. Constraints 1 (1996) 7–43 3. Katsirelos, G., Bacchus, F.: Generalized nogoods in CSPs. In: AAAI 2005. 390–396