The PN model is learned from T, as explained later, and it is tested by performing inference to predict the offender variables (OFF) in the validation cases V. An offender profile is estimated based on crime scene evidence, with a prediction being the most likely value of a particular offender variable. 

During the testing phase, the predicted value of XOi , denoted by xPi,a where a=1 or 2 for a binary variable, is compared to the observed state xOi,b obtained from the validation set V, where b=1 or 2. An example of an offender variable is "gender", with states "male" and "female". The overall performance of the PN model is evaluated by comparing the true (observed) states xOi,b to the predicted output variable values xPi,a in the validation cases. This process tests the generalization properties of the model by evaluating its efficiency over V. 

## Iii. Variables Considered

The relevant categories of variables that have emerged from the criminal profiling research as selected by investigators, criminologists, and forensic psychologists are described as follows: - *Crime Scene Analysis* (CSA): CSA variables are systematic observations made at the crime scene by the investigator. Examples of CSA variable pertain to where the body was found (e.g., neighborhood, location, environment characteristics), how the victim was found (e.g., the body was well-hidden, partially hidden, or intentionally placed for discovery), and the correlation between where the crime took place and where the body was found (e.g., the body was transported after the murder). - *Victimology Analysis* (VA): VA variables consist of the background characteristics of the victim independent of the crime. For example, VA variables include the age, sex, race, education level, and occupation of the victim. - *Forensic Analysis* (FA): FA variables rely on the medical examiner's report that deals with the autopsy. Examples of this are time of death, cause of death, type of non-lethal wounding, wound localization, and type of weapon that administered the wounds. The set of CP variables used in this paper were defined in previous research [4, 5, 7, 8]. The selection criteria for variable selection [6] are: (i) Behaviors are clearly observable and not easily misinterpreted (ii) Behaviors are reflected in the crime scene, e.g., type of wounding, and 
(iii) Behaviors indicate how the offender acted toward and interacted with the victim 
(IJCSIS) International Journal of Computer Science and Information Security, Vol. 7, No. 1, 2010 T and a validation set V, such that D = T U V. The variables in X are partitioned as follows: the inputs are the crime scene 
(CS) variables XI (evidence) for XI = (XI1 , ...,XIk ), and the outputs are the offender (OFF) variables comprising the criminal profile XO, for XO = (XO1 , ...,XOm), where (XI ,XO) ε X. 

e.g., victim was bound/gagged, or tortured. Some crime scene 
(CS) variables describing the observable crime scene and offender (OFF) variables describing the actual offender were selected based on the above criteria. Examples of the CS 
variables are multiple wounding to one area, drugging the victim, and sexual assault. Examples of the offender variables include prior offenses, relationship to the victim, prior arrests, etc. The variables all have binary values representing whether the event was present or absent. 

## Iv. Training The Model

The basic schematic of the training software, including the 

![0_image_0.png](0_image_0.png)

validation process, is shown in Figure 1, where Ph is the proposed PN and Popt is the trained (or optimized) PN. The software is intended to aid law enforcement in the investigation of violent crimes. Because the cases are unsolved and only the crime scene inputs are known, the criminal profiling software consists of a trained PN model that has been previously trained and validated with D. Also, the model has the potential to be updated by means of an incremental training algorithm when additional cases are solved by the police. Thus, Ptrained consistently reflects the model of an evolving criminal profile over time. 

## V. Data Base Of Solved Cases

A set of single offender/single victim homicides was collected by psychologists from solved homicide files of the British police [4, 6]. In order to examine the aggressive behavioral patterns of a particularly violent offense, the criteria for case selection is: single offender/single victim homicide cases; a mixture of domestic (where the victim and offender were known to each other (e.g., family member, spouse, co-worker) and stranger (the offender is unknown to the victim, thus they had no previous links to each other) cases; offenders are adults at least 17 years of age, as defined by the court system. Excluded from the sample were cases when the cause of death was not aggressive or extremely intentional. Homicides by reckless driving are not included due to the lack of interpersonal interaction between the offender and victim. 

## Vi. Sampling

A simulation set is built to produce an artificial CP database to study the PN learning and inference capabilities. This included a more extensive list of crime scene, offender characteristics 