(IJCSIS) International Journal of Computer Science and Information Security, Vol. 7, No. 1, 2010 and multiple-valued variables. A PN is used to simulate a set of cases where the crime scene and offender variables can be chosen by the user. An initial structure thus relating the variables and the corresponding initial probabilistic parameters θ0 are declared based on the prior knowledge, through experience, or by sampled statistics. Cases are simulated by feed forward sampling, where variables are sampled one at a time in order from top-level variables (variables without parents), to the mid-level variables (variables with both parents and children), ending with the bottom-level variables (children variables with parents only). For each variable, the discrete conditional prior probabilities in vector form are given as: 
 [P(xi,1| πi ), (xi,2| πi ),….., (xi,ri| πi )] where ri is the maximum state for Xi and πi disappears if Xi is a top-level variable. A value vi is drawn from a uniform continuous distribution between '0' and '1' and the conditional prior probability vector as a vector of ranges becomes 
[P(xi,1| πi ),P(xi,1| πi )+ P(xi,2| πi ),….., 
i=
∑ i,j| π*i )] which refers to* 

$$\sum\,(x_{i,j}|\,\pi_{i})J\,\,\,w$$
1
i
r
$\square$
Xi= 

$$\mathbf{M}$$

![0_image_1.png](0_image_1.png)

To simulate a set of cases for the system represented by the three-nodal model illustrated in Figure 2, the variables are ordered as (X1, X2, X3), where X1 is the parent of X2 and X3, and X1 = (x1,1, x1,2), X2 = (x2,1, x2,2) and X3 = (x3,1, x3,2). Starting with X1, it has three possible states with the prior probabilities P(x1,1) = 0.2, P(x1,2) = 0.5, and P(x1,3) = 0.3, which becomes a vector [0.2, 0.7, 1] referring to: 

$$\mathbf{\hat{n}}$$

X1 = 

$\mathbf{x}_{1,1}$ if $0\leq\mathbf{v}_{1}\leq0.2$  $\mathbf{x}_{1,2}$ if $0.2\leq\mathbf{v}_{1}\leq0.9$  $\mathbf{x}_{1,3}$ if $0.9\leq\mathbf{v}_{1}\leq1$
(2)  $\frac{1}{2}$ . 

 (2) 
$\mathbf{a}$
 
If v1 = 0.11 which makes X1 = x1,1, and the Conditional 

![0_image_0.png](0_image_0.png)

Probability Table (CPT) for X2 is listed in Table 1. Then the conditional prior probability vector of ranges for a newly generated v2 becomes 

$$\left.\begin{array}{l}{{\mathrm{X}_{2}=\ \ }}\\ {{\mathrm{\ }}}\\ {{\mathrm{\ }}}\end{array}\right\}$$
$$\mathbf{x_{2,1}}{\mathrm{if~}}0\leq\mathbf{v_{2}}<0.2$$  $$\mathbf{x_{2,2}}{\mathrm{if~}}0.2\leq\mathbf{v_{2}}<1$$
$\eqref{eq:walpha}$
 (3) 
X3 is sampled following the same procedure as X1 and X2. 

This is repeated until the desired number of cases as specified by the user is reached. The Matlab function utilized for the sampling exercise is sample b_net in the Bayes Net Toolbox 
[2]. 

## Vii. Pn Predictions And Accuracy

When a PN model of offender behavior on the crime scene is learned from solved cases, it is implemented on a set of solved validation cases in order to test the trained model's performance. Performance is tested through probabilistic inference. Inference is the process of updating the probability distribution of a set of possible outcomes based upon the relationships represented by the PN model and the observations of one or more variables. With the updated probabilities, a prediction can be made from the most likely value of each inferred variable. Thus, in order to test the trained model, only the crime scene evidence is inserted into the model, with the predicted offender profile being compared to the actual offender characteristics. Because this is a probabilistic model, a certain confidence accompanies the offender variable predictions. 

## Viii. Conclusions

This paper presents an approach for deriving a network model of criminal profiling that draws on knowledge-based systems and on fields of criminology and offender profiling. Implementing probabilistic networks makes it possible to represent multidimensional interdependencies between all relevant variables that have been identified in previous research as playing a role in determining or reflecting the behavior of offenders at the crime scene. Hence, a valid 