Gianna [25] is a precursor visual environment for modeling CSP. But its modeling style is not object-oriented and the level of abstraction provided is lower than in UML-like languages. In this tool, CSPs are stated as constraint graphs where nodes represent the variables and the edges represent the constraints.

Although these approaches do not have a system to plug-in new solvers and were developed for a specific application domain, we believe it is important to mention them.

It is important to clarify too, that object-oriented capabilities are also provided by languages such as CoJava [4]; and in libraries such as Gecode or ILOG SOLVER. The main difference here is that the host language provided is a programming language but not a high-level modeling language. As we have explained in Section 1, advanced programming skills may be required to deal with these tools.

## 7. Conclusions And Future Work

In this work we have presented **s-COMMA**, an extensible MDD
platform for modeling CSPs. The whole system is composed by two main parts: A modeling tool and a mapping tool, which provide to the users the following three important facilities:
- A visual modeling language that combines the declarative aspects of constraint programming with the useful features of object-oriented languages. The user can state modular models in an intuitive way, where the compositional structure of the problem can be easily maintained through the use of objects under constraints.

- Models are stated independently from solver languages. Users are able to design just one model and to target different solvers.

This clearly facilitates experimentation and benchmarking.

- A model transformation system supported by the AMMA platform which follows the standards of the software engineering field. The system allows users to plug-in new solvers without writing translators by hand.

Currently, we do not use **s-COMMA** as our source model, because its metamodel is quite large and defining generic mappings to different solver metamodels will be a serious challenge. However we believe that this task will lead to an interesting future work, for instance to perform reverse engineering (e.g. Gecode/J to **sCOMMA** or ECLiPSeto **s-COMMA**). The use of AMMA for model optimization will be useful too, for instance to eliminate redundant or useless constraints. The definition of selective mappings is also an interesting task, for instance to decide, depending on the solver used, whether loops must be unrolled or the composition must be flattened.

## Acknowledgments

We are grateful to the support of this research from the "Pontificia Universidad Cat´olica de Valpara´ıso" under the grant "Beca de Estudios B´asica", and to Fr´ed´eric Jouault for his support on the implementation of the AMMA translators.

References
[1] ANTLR Reference Manual, 2007. http://www.antlr.org. [2] F. Baader and T. Nipkow. Term rewriting and all that, Cambridge Univ.

Press, 1998.

[3] A. Borning. The Programming Languages Aspects of ThingLab, a Constraint-Oriented Simulation Laboratory. *ACM Transactions on* Programming Languages and Systems (ACM TOPLAS), 3(4), pages 353–387, 1981.

[4] A. Brodsky and H. Nash. CoJava: Optimization Modeling by Nondeterministic Simulation. In Proceedings of the 12th International
Conference on Principles and Practice of Constraint Programming (CP 2006) 3(4). LNCS, vol. 4204, pages 91–106, 2006.

[5] S. Brand, G. J. Duck, J. Puchinger and P. J. Stuckey. Flexible, RuleBased Constraint Model Linearisation. In *Proceedings of the 10th* Symposium on Practical Aspects of Declarative Languages (PADL 2008). LNCS, vol. 4902, pages 68–83, 2008.

[6] D. Diaz and P. Codognet. The GNU Prolog System and its Implementation. In *Proceedings of the 2000 ACM Symposium on Applied* Computing (SAC 2000), pages 728–732, 2000.

[7] Eclipse Model-to-model transformation, 2008.

http://www.eclipse.org/m2m/.

[8] A. M. Frisch, C. Jefferson, B. Mart´ınez Hern´andez and I. Miguel. The Rules of Constraint Modelling. In Proceedings of the 19th International Joint Conference on Artificial Intelligence (IJCAI 2005), pages 109–116, 2005.

[9] A. M. Frisch, M. Grum, C. Jefferson, B. Mart´ınez Hern´andez and I. Miguel. The Design of ESSENCE: A Constraint Language for Specifying Combinatorial Problems. In *Proceedings of the 20th* International Joint Conference on Artificial Intelligence *(IJCAI 2007)*, pages 80–87, 2007.

[10] P. Fritzson and V. Engelson. Modelica - A Unified Object-Oriented Language for System Modeling and Simulation. In Proceedings of the 12th European Conference on Object-Oriented Programming (ECOOP 1998). LNCS, vol. 1445, pages 67–90, 1998.

[11] T. W. Fr¨uhwirth. Theory and Practice of Constraint Handling Rules.

Journal of Logic Programming 37(1-3), pages 95–138, 1998.

[12] Gecode System, 2006. http://www.gecode.org. [13] I. P. Gent, C. Jefferson and I. Miguel. Minion: A Fast Scalable Constraint Solver. In *Proceedings of the 17th European Conference on* Artificial Intelligence (ECAI 2006), pages 98–102, 2006.

[14] L. Granvilliers and F. Benhamou. Algorithm 852: RealPaver:
an interval solver using constraint satisfaction techniques. ACM Transactions on Mathematical Software (ACM TOMS), 32(1), pages 138–156, 2006.

[15] J. Jaffar and J.-L. Lassez. Constraint Logic Programming. In Proceedings of the 14th Annual ACM Symposium on Principles of Programming Languages (POPL 1987), pages 111–119, 1987.

[16] B. Jayaraman and P. Tambay. Modeling Engineering Structures with Constrained Objects. In Proceedings of the 4th Symposium on Practical Aspects of Declarative Languages (PADL 2002). LNCS, vol. 2257, pages 28–46, 2002.

[17] F. Jouault and I. Kurtev. Transforming Models with ATL. In Proceedings of Satellite Events at the 8th International Conference on Model Driven Engineering Languages and Systems (MoDELS Satellite Events 2005). LNCS, vol. 3844, pages 128–138, 2005.

[18] F. Jouault and J. B´ezivin. KM3: A DSL for Metamodel Specification.

In Proceedings of the 8th IFIP WG 6.1 International Conferenceon Formal Methods for Open Object-Based Distributed Systems (FMOODS 2006). LNCS, vol. 4037, pages 171–185, 2006.

[19] F. Jouault, J. B´ezivin and I. Kurtev KM3: A DSL for Metamodel Specification. In Proceedings of the 5th International Conference on Generative Programming and Component Engineering (GPCE 2006), pages 249–254, 2006.

[20] I. Kurtev, J. B´ezivin, F. Jouault and P. Valduriez. Model-based DSL frameworks. In Proceedings of Companion to the 21th Annual ACM SIGPLAN Conference on Object-Oriented Programming, Systems, Languages, and Applications (OOPSLA Companion 2006), pages 602– 616, 2006.

[21] N. Nethercote, P. J. Stuckey, R. Becket, S. Brand, G. J. Duck and G. Tack. MiniZinc: Towards a Standard CP Modelling Language. In Proceedings of the 13th International Conference on Principles and Practice of Constraint Programming (CP 2007) 3(4). LNCS, vol. 4741, pages 529–543, 2007.

[22] OMG - Object Constraint Language (OCL) 2.0, 2006.