the introduction of a solver-independent visual language - which we believe is intuitive and simple enough for non experts –, and the use of a MDD approach involving metamodeling techniques to implement the mappings.

The outline of this paper is as follows. The MDD architecture proposed is introduced in Section 2. The **s-COMMA** modeling language and the associated graphical interface are presented in Section 3. The mapping tool and the metamodeling techniques used to develop solver-translators are explained in Section 4. Some experimental results are then discussed in Section 5. The related work and conclusion follows.

## 2. A Mdd Approach For Cp

Model-Driven Engineering (MDE) aims to consider models as first class entities. A model is defined according to the semantics of a model of models, also called a **metamodel**. A metamodel describes the concepts appearing in a model, but also the links between these concepts, such as: inheritance, composition or simple association.

Figure 1 depicts a general Model-Driven Architecture (MDA)
for model transformation. Level M1 holds the model. Level M2 describes the semantic of the level M1 and thus identifies concepts handled by this model through a metamodel. Level M3 is the specification of level M2 and is self-defined. Transformation rules are defined to translate models from a source model to a target one, the semantic of these rules is also defined by a metamodel.

A major strength of using this metamodeling approach is that models are concisely represented by metamodels. This allows one to define transformation rules that only operate on the concepts of metamodels (at the M2 level of the MDA approach), not on the concrete syntax of a language. Syntax concerns are defined independently (we illustrate this in Section 4). This separation is a great advantage for a clearly definition of transformation rules and grammar descriptions, which are the base of our mapping tool.

![0_image_1.png](0_image_1.png)

Let us now illustrate how this approach is implemented in our platform. Figure 2 shows the MDD **s-COMMA** architecture, which is composed by two main parts, a modeling tool and a mapping tool.

The **s-COMMA GUI** is our modeling tool, and it allow users to state constraint models using visual artifacts. An exactly textual representation of this language is also provided (for who does not want to use visual artifacts). Both languages are solver-independent and are designed conform to the same metamodel (see Section 3).

The output of the s-COMMA GUI is **Flat s-COMMA** an intermediate language which is still solver-independent but, in terms of abstraction is closer to the solver level. The goal is to simplify the development of solver-translators. **Flat s-COMMA** is also designed conform to a metamodel (see Section 3.3).

The mapping tool is composed by a set of solver-translators.

![0_image_0.png](0_image_0.png)

Solver-translators are designed to match the metamodel concepts of **Flat s-COMMA** to the concepts of the solver metamodel (see Section 4). This process is defined conform to the general MDA for model transformation.

Figure 2. The MDD architecture of s-COMMA.
The **s-COMMA GUI** is written in Java (about 30000 lines) and translators are developed using the AMMA platform. The whole system allows to perform the complete process from visual models to solver models. The system involves several metamodels: an **sCOMMA** metamodel, a **Flat s-COMMA** and solver metamodels.

The **s-COMMA** metamodel has been built just for defining the concepts of the **s-COMMA** textual and visual language, it is not used to map s-COMMA to **Flat s-COMMA**. For this task we already have an efficient translator. Our key aim of using metamodeling techniques is to provide an easier way to develop new solvertranslators, compared to the task of writing translators by hand.

In the following two sections we present the main parts of this architecture: The modeling and the mapping tool, respectively.

## 3. Modeling Tool

We have built our **s-COMMA GUI** modeling tool on top of the **sCOMMA** language. The **s-COMMA** language is defined through its metamodel and it has been designed to represent the concepts of constraint problems, also called constraint satisfaction problems
(CSPs). In this metamodel, the CSP concepts such as variables and domains have been merged with object-oriented concepts in order to state CSPs using an object-oriented style. The result is an objectoriented visual language for modeling CSPs. These decisions are supported by the following benefits:
- A problem is generally composed of several parts which may represent objects. They are naturally specified through classes.

Thus, we obtain a more modular model, instead of forcing modelers to state the entire problem in a single block of code.

- We gain similar benefits - constraint and variable encapsulation, composition, inheritance, reuse - to those gained by writing software in a object-oriented programming language.

- Visual artifacts are more intuitive to use and give a clearer view of the complete structure of the problem.

Figure 3 illustrates the main concepts of the **s-COMMA** metamodel using UML class diagram notation. The role of each one of these concepts is explained in the following paragraphs.

## 3.1 S-Comma Models

The **s-COMMA** metamodel defines the concepts appearing in **sCOMMA** models. Thus, conform to this metamodel an **s-COMMA**
model must be composed by two main parts, the model and data.

The model describes the structure of the problem and the data contain the constant values used by the model. In our **s-COMMA GUI**
front tool this problem's structure is represented by class artifacts