The problem is to find a matching between the groups such that the marriages are stable i.e., there are no pair of people of opposite sex that like each other better than their respective spouses.

Figure 5 shows a snapshot of the **s-COMMA GUI** where the stable marriage problem is represented by a class diagram. This diagram is composed by three classes, one class to represent men, one to represent women, and a main class to describe the stable marriages. Once the user states a visual artifact, the corresponding s-COMMA textual version is automatically generated on the rightpanel of the tool. For readability we illustrate the textual version of the problem in Fig. 6

//Model file
1. import StableMarriage.dat; 2.
3. class StableMarriage { 4.
5. Man man[menList];
6. Woman woman[womenList]; 7.
8. constraint matchHusbandWife {
9. forall(m in menList)
10. woman[man[m].wife].husband = m; 11.
12. forall(w in womenList)
13. man[woman[w].husband].wife = w; 14. } 15.
16. constraint forbidUnstableCouples {
17. forall(m in menList){ 18. forall(w in womenList){
19. man[m].rank[w] < man[m].rank[man[m].wife] ->
20. woman[w].rank[woman[w].husband] < woman[w].rank[m]; 21. 22. woman[w].rank[m] < woman[w].rank[woman[w].husband] ->
23. man[m].rank[man[m].wife] < man[m].rank[w];

![0_image_0.png](0_image_0.png) ![0_image_1.png](0_image_1.png)

37. }
//Data file
1. enum menList := {Richard,James,John,Hugh,Greg}; 2. enum womenList := {Helen,Tracy,Linda,Sally,Wanda};
3. Man StableMarriage.man := [Richard: {[Helen:5 ,Tracy:1, Linda:2, Sally:4, Wanda:3],_}, James : {[Helen:4 ,Tracy:1, Linda:3, Sally:2, Wanda:5],_}, John : {[Helen:5 ,Tracy:3, Linda:2, Sally:4, Wanda:1],_}, Hugh : {[Helen:1 ,Tracy:5, Linda:4, Sally:3, Wanda:2],_}, Greg : {[Helen:4 ,Tracy:3, Linda:2, Sally:1, Wanda:5],_}];
Wanda: {[Richard:4, James:2, John:3, Hugh:5, Greg:1],_}];
  **  **Homam StableArriage.woman :=**  {Helen: {Hichard:1, James:2, John:4, Hugh:3, Greg:5},.},  **Tracy: {{Hichard:3, James:5, John:1, Hugh:2, Greg:4},.},  **Linda: {{Hichard:5, James:4, John:2, Hugh:1, Greg:3},.},  **Sally: {{Hichard:1, James:3, John:5, Hugh:4, Greg:2},.},**

## Figure 6. An S-Comma Model For The Stable Marriage Problem.

The class representing men (at line 29 in the model file) is composed by one array containing integer values which represents the preferences of a man, the array is indexed by the enumeration type **womenList** (at line 2 in the data file), thereby the 1st index of the array is **Helen**, the 2nd is **Tracy**, the third is **Linda** and so on. Then, an attribute called **wife** is defined (line 31), which represents the spouse of an object man. This variable has **womenList** as a type which means that its domain is given by the enumeration womenList. The definition of the class **Women** is analogous.

The class **StableMarriage** has a more complex declaration. We first define two arrays, one called man which contains objects of the class Man and other which contains objects of the class **Woman**.

Each one represents the group of men and the group of women, respectively. The composition relationship between classes can be seen on the class diagram.

At line 8 a constraint zone called **matchHusbandWife** is stated.

In this constraint zone, two **forall** loops including a constraint are posted to ensure that the pairs man-wife match with the pairs woman-husband. The **forbidUnstableCouples** constraint zone contains two loops including two logical formulas to ensure that marriages are stable.

The data file is called by means of an import statement (at line 1). This file contains two enumeration types, **menList** and womenList, which have been used in the model as a type, for indexing arrays, and as the set of values that loop-variables must traverse. **StableMarriage.man** is a variable-assignment for the array called man defined at line 5 in the model file.

This variable-assignment is composed by five objects (enclosed by '{}'), one for each men of the group. Each of these objects has two elements, the first element2is an array (enclosed by **'[ ]'**).

This array sets the preferences of a men, assigning the values to the array **rank** of a Man object (e.g. Richard prefers Tracy 1st, Linda 2nd, Wanda 3rd, etc).

The second element is an underscore symbol (' '). This symbol is used to omit assignments, so the variable **wife** remains as a decision variable of the problem i.e., a variable for which the solver must search a solution.

## 3.3 Flat S-Comma Models

Before explaining how **s-COMMA** models are mapped to their

![0_image_2.png](0_image_2.png)

equivalent solver models, let us introduce the intermediate **Flat sCOMMA** language.

![0_image_3.png](0_image_3.png)

Flat s-COMMA has been designed to simplify the transformation process from **s-COMMA** models to solver models. In **Flat sCOMMA** much of the constructs supported by **s-COMMA** are transformed to simpler ones, in order to be closer to the form required by classical solver languages. **Flat s-COMMA** is also defined by a metamodel.

Figure 7 illustrates the main elements of the **Flat s-COMMA**
metamodel, where many **s-COMMA** concepts have been removed.

Now, the metamodel is mainly a definition of a problem composed by variables (decision variables) and constraints.

In order to transform s-COMMA to **Flat s-COMMA**, several steps are involved, which are explained in the following.

2 Let us note that we use standard modeling variable-assignments, that is, assignments are performed respecting the order of the class' attributes: the first element of the variable-assignment is matched with the first attribute of the class, the second element of the variable-assignment with the second attribute of the class and so on.