- Enumeration substitution: In general solvers do not support non-numeric types. So, enumerations are replaced by integer values. However, enumeration values are stored to show the results in the correct format.

- Data substitution: Data variables stated in the model file are replaced by their corresponding values i.e., the value defined in the data file.

- Loop unrolling: Loops are not widely supported by solvers, hence we generate an unrolled version of the forall loop.

- Flattening composition: The hierarchy generated by composition is flattened. This process is done by expanding each object declared in the main class adding its attributes and constraints in the **Flat s-COMMA** file. The name of each attribute has a prefix corresponding to the concatenation of the names of objects of origin in order to avoid name redundancy.

- Conditional removal: Conditional statements are transformed to logical formulas. For instance, **if a then b else c** is replaced by (a ⇒ b) ∧ (a ∨ c).

- Logic formulas transformation: Some logic operators are not supported by solvers. For example, logical equivalence (a ⇔ b) and reverse implication (a ⇐ b). We transform logical equivalence expressing it in terms of logical implication ((a ⇒
b) ∧ (b ⇒ a)). Reverse implication is simply inverted (b ⇒ a).
1. variables: 2.
  **TheoremList man_wife[5] in [1,5];**  **LemmaList woman_hushand[5] in [1,5];**
5.
7.
8. woman_husband[man_wife[1]]=1; 9. woman_husband[man_wife[2]]=2;
10. woman_husband[man_wife[3]]=3;
$\texttt{constraints}\!:\!1$

![0_image_0.png](0_image_0.png)

11. ...

![0_image_1.png](0_image_1.png)

![0_image_2.png](0_image_2.png)

12. 13. man_wife[woman_husband[1]]=1;
14. man_wife[woman_husband[2]]=2;
15. man_wife[woman_husband[3]]=3; 16. ...
17.
18. 5<man_1_rank[man_wife[1]] ->
19. woman_1_rank[woman_husband[1]]<1; 20. 1<woman_1_rank[woman_husband[1]] ->
21. man_1_rank[man_wife[1]]<5;
22.
23. 1<man_1_rank[man_wife[1]] ->
24. woman_2_rank[woman_husband[2]]<3;
25. 3<woman_2_rank[woman_husband[2]] ->
26. man_1_rank[man_wife[1]]<1; 27. ...
28.
29. enum-types: 30.
31. menList := {Richard,James,John,Hugh,Greg}; 32. womenList := {Helen,Tracy,Linda,Sally,Wanda};
Figure 8. The Flat s-COMMA model of the stable marriage problem.

Figure 8 depicts the **Flat s-COMMA** model of the stable marriage problem. The file is composed of two main parts, variables and constraints. Variables at lines 3-4 are generated by the flattening composition process. The array man composed by objects of type Man is decomposed and transformed to a single array of decision variables. The array man **wife** contains the decision variables wife of the original array man; and the array woman **husband** contains the decision variables **husband** of the original array **woman**. The arrays rank of both objects Man and **Woman** are not considered as decision variables since they have been filled with constants (at lines 3-4 of the data file in Figure 6). The size of the array man **wife** is 5, this value is given by the enumeration substitution step which sets the size of the array with the size of the enumeration **menList** (5).

The domain **[1,5]** is also given by this step which states as domain an integer range corresponding to the number of elements of the enumeration used as a type (**womenList**) by the attribute **wife**. The type of both arrays is maintained to give the solutions in the enumeration format. These values are stored in the block **enum-types**.

Lines 8-15 come from the loop unrolling phase of the forall statements of the **matchHusbandWife** constraint zone. Likewise, lines 18-26 are generated by the loops of **forbidUnstableCouples**. In these constraints, the data substitution step has replaced several constants with their corresponding integer values.

## 4. Mapping Tool

In this section we explain the mechanisms provided by the MDD
approach to develop our solver-translators. These translators are designed to perform the mapping from **Flat s-COMMA** to solver models. We use the AMMA platform as our base tool to build them.

The AMMA platform allows one to develop this task by means of two languages: KM3 [18] and ATL [17]. KM3 is used to define metamodels, and ATL is used to describe the transformation rules and also to generate the target file.

## 4.1 Km3

The Kernel Meta Meta Model (KM3) is a language to define metamodels. KM3 has been designed to support most metamodeling standards and it is based on the simple notion of classes to define each one of the concepts of a metamodel. These concepts will then be used by the transformation rules and to generate the target file. Figure 9 illustrates an extract of the **Flat s-COMMA** metamodel written in KM3.

  `lases Problem {`   `attribute name : String;`   `reference variables[1-*] container : Variable;`   `reference constraints[0-*] container : Constraint;`   `reference ennumTypes[0-*] container : EnunType;`   `
6. }
7.
8. class Variable { 13. }
14.
15. class Array { 16. attribute row : Integer; 17. attribute col[0-1] : Integer;
  **Attribute name : String; attribute type : String; reference array [0-1] container : Array; reference domain container : Domain;**

![0_image_3.png](0_image_3.png)

18. }
The **Flat s-COMMA** KM3 metamodel states that the concept Problem is composed of one attribute and three references. The attribute **name** at line 2 represents the name of the model and it is declared with the basic type **String**. Line 3 simply states that the class **Problem** is composed by a set of objects of the class Variable. The reserved word **reference** is used to declare links with instances of other classes and the statement **[1-*]** defines the multiplicity of the relationship. If the multiplicity statement is omitted the relationship is defined as **[1-1]**. Lines 4-5 are similar and define that the class **Problem** is also composed by **constraints**
and **enumTypes** (values stored by the enumeration substitution step).

Remaining classes are defined in the same way.

$\epsilon$ . 

## Figure 9. An Extract Of The Flat S-Comma Km3 Metamodel.
