variables (e) is checked to determine whether it has been defined as a set matrix (line 14). If this occurs, the helper **getMatrixCells(e)**
calculates the set of tuples corresponding to all the cells of the matrix (**thisModule** is used to call explicitly helpers or rules).

Each tuple is composed of the **Flat s-COMMA** variable (**f.var**),
a row index (f.i) and a column index (f.j). Then, the rule SetMatrixVariable2Variable is applied to each tuple in order to generate the ECLiPSevariables. This rule does not contain a source block since the source elements are the input parameters.

The rule sets to the attribute **name**, the concatenation of the name of the matrix with the respective row (**i.toString()**) and column
(**j.toString()**). Attributes **type** and **domain** are also matched. Finally, **flatten()** is an OCL inherited method used to match the generated set of variables with **t.variables**.

ATL is also used to generate the solver target file. This is possible by defining a new ATL file (called generically ATL2Text)
where we can embed the concepts of the metamodel in the syntax of the target file. This is done by means of a querying facility that enables to specify requests onto models.

1. query GecodeJ2Text = GecodeJ!Problem.allInstances()->
2. asSequence()->first().toString2().

3. writeTo('./GecodeJ/Samples/'+ thisModule.getFileName() + 4. '.java');
5.

6. helper context GecodeJ!Problem def: toString2() : String= 7. 'package comma.solverFiles.gecodej;\n' +
8. 'import static org.gecode.Gecode.*;\n' +
9. 'import static org.gecode.GecodeEnumConstants.*;\n' +
10. ... 11. 12. self.variables->collect(e | e.toString2()) 13. ->iterate(e; acc:String = '' | acc +' '+e) + 14. ... 15. '}\n\n' 16. ;
17. 18. helper context GecodeJ!Variable def: toString2() : 19. String= 20. if self.array.oclIsUndefined() then 21. 'IntVar ' + self.name + ' = new IntVar(this,\"' + 22. self.name + '\",' + self.domain.toString2() +');\n' +
23. ' vars.add('+ self.name +');\n' 24. else if self.array.col.oclIsUndefined() then 25. 'VarArray<IntVar> ' + self.name + ' = initialize(\"' + 26. self.name + '\",' + self.array.toString2() + 27. ',' + self.domain.toString2()+');\n' + 28. ' vars.addAll(' + self.name + ');\n' 29. else 30. 'VarMatrix<IntVar> ' + self.name + ' = initialize(\"' +
31. self.name + '\",' + self.array.toString2() + 32. ',' + self.domain.toString2()+');\n' + 33. ' vars.addAll(' + self.name + ');\n' 34. endif endif 35. ;

1. template Problem 2. : "variables" ":" variables 3. "constraints" ":" constraints 4. "enum-types" ":" enumTypes 5. ; 6.

7. template Variable 8. : type name (isDefined(array) ? array) "in" domain ";"
9. ; 10.

11. template Array 12. : "[" row (isDefined(col) ? "," col ) "]" 13. ;
self.array.oclIsUndefined() checks whether the concept array is undefined. If this occurs, the variable corresponds to a single variable. The string representing this declaration uses **self.name** which refers to the name of the variable, **self.domain.toString2()** calls a helper to get the string representing the domain of the variable.

The next alternative tests if the attribute col of the **array** is undefined, in this case the variable is a one dimension array, otherwise it is a two dimension array. The call **self.array.toString2()** is used in the two last alternatives, it returns the string corresponding to the size of arrays.

Figure 13 depicts an extract of the Gecode/J file generated for the stable marriage problem. Lines 1-3 states the headers. Line 6 declares the array called man **wife**. which is initialized with size 5 and domain **[1,5]**. At line 8 the array is added to a global array called **vars** for performing the labeling process. Lines 14-19 illustrate some constraints, which are stated by means of the **post**
method.

1. package comma.solverFiles.gecodej; 2. import static org.gecode.Gecode.*;
3. import static org.gecode.GecodeEnumConstants.*;
4. ... 5.

6. VarArray<IntVar> man_wife =
7. initialize("man_wife",5,1,5); 8. vars.addAll(man_wife);
9.

10. VarArray<IntVar> woman_husband =
11. initialize("woman_husband",5,1,5); 12. vars.addAll(woman_husband);
13.

14. post(this, new Expr().p(get(this,woman_husband, 15. get(man_wife,1))),IRT_EQ, new Expr().p(1));
16. post(this, new Expr().p(get(this,woman_husband, 17. get(man_wife,2))),IRT_EQ, new Expr().p(2));
18. post(this, new Expr().p(get(this,woman_husband, 19. get(man_wife,3))),IRT_EQ, new Expr().p(3));
20. ...

Figure 13. Gecode/J model for the stable marriage problem.

## 4.3 Tcs

TCS [19] (Textual Concrete Syntax) is another language provided by the AMMA platform. TCS is not mandatory to add a new translator but it is involved in the process since it is the language used to parse the **Flat s-COMMA** file. TCS is able to perform this task by bridging the **Flat s-COMMA** metamodel with the **Flat sCOMMA** grammar.

## Figure 12. Gecodej2Text File

Figure 12 shows a fragment of the GecodeJ2Text definition to generate the Gecode/J file. Lines 1-4 states the query on the Problem concept and defines the target file. Queries are able to call helpers, which allow us to build the string to be written in the target solver file. This query calls the helper **toString2()** defined for the concept **Problem**. This helper is stated at line 6 and it creates first the string corresponding to the headers (package and import statements) of a Gecode/J model. Then, at lines 12-13 the string corresponding to the variables declarations is created. This is done by iterating the collection of variables and calling the corresponding toString2() helper for the **Variable** instances. This helper is declared at line 18, it defines three possible variable declarations, single variable (**IntVar**), a one dimension array (**VarArray<IntVar>**),
and a two dimension array (**VarMatrix<IntVar>**). The alternatives are chosen by means of an if-else statement. The condition

## Figure 14. Tcs For Flat S-Comma.

Figure 14 shows an extract of the TCS file for **Flat s-COMMA**.

Each class of the **Flat s-COMMA** metamodel has a dedicated template declared with the same name. Within templates, words between double quotes are tokens in the grammar (e.g. **"variables"**,
":"). Words without double quotes are used to introduce the corresponding list of concepts. For instance **variables** is defined as a