reference to objects **Variable** in the class **Problem** of the metamodel. Thus, **variables** is used to call their associate template i.e., the **Variable** template. This template defines the syntactic structure of a variable declaration. It has a conditional structure (**(isDefined(array) ? array)**), which means that the template Array is only called if the variable is defined as an array.

## 4.4 Transformation Process

TCS and KM3 work together and their compilation generates a Java package (which includes lexers, parsers and code generators) for Flat s-COMMA (FsC), which is then used by the ATL files to generate the target model. Figure 15 depicts the complete transformation process. The **Flat s-COMMA** file is the output of the **s-COMMA**
GUI, this file is taken by the Java package which generates a XMI 3
(XML Metadata Interchange) for **Flat s-COMMA**, this file includes an organized representation of models in terms of their concepts in order to facilitate the task of transformation rules. Over this file ATL rules act and generate a XMI file for Gecode/J. Finally this file is taken by the Gecode/J2Text which builds the solver file. Figure 15. The AMMA model-driven process on the example of

![0_image_1.png](0_image_1.png)

Flat s-COMMA (FsC) to Gecode/J.

The complete process involves TCS, KM3 and ATL. But, the integration of a new translator just requires KM3 and ATL (the mapping tool only needs one TCS file). As we mention in Section 4.2, solver metamodels are almost equivalents, and ATL rules are mainly one to one mappings. As a consequence, the development of KM3 and ATL rules for new solver-translators should not be a hard task. So, we could say that the concrete work for plugging a new solver is reduced to the definition of the ATL2Text file.

Currently, There are two versions of our mapping tool, one with AMMA translators and one with translators written by hand (in Java), which we got from a preliminary development phase of the system. Comparing both approaches, let us make the following concluding remarks.

- The development of hand-written translators is in general a hard task. Their creation, modification and reuse require to have a deep insight in the code and in the architecture of the platform, even more if they have a specific and/or complex design. For instance, the developer may be forced to directly use lexers and parsers, or a given library which provides specific methods to generates the target files.

- The development of AMMA translators does not require advanced language implementation skills. We show that the use of KM3 and ATL is not really a hard task. Moreover, AMMA is supported by a set of tools [7] which provide a great framework to create and manipulate KM3, ATL and TCS models, and also for project handling. An independent definition of syntax concerns (ATL2Text) from metamodel concepts (KM3) is another advantage which gives us a more organized view that facilitates the creation and reuse of translators.
3 XMI is the standard used for exchanging metadata in MDD architectures.

- The development of hand-written translators requires more code lines. In our implementation, the source files of Java translators are approximately 60% bigger than the AMMA translators source files (ATL+KM3).

## 4.5 Direct Code Generation

There is another approach to develop translators using the AMMA
platform. For instance, if we want to use just the **Flat s-COMMA**
features that are supported by the solver, we can omit the transformation rules and we can apply the ATL2Text directly on the source metamodel. Figure 16 shows this direct code generation process.

![0_image_0.png](0_image_0.png)

Figure 16. Direct code generation.
Although this approach is simpler, it is less flexible since we lose the possibility of using interesting rules transformations such as the set matrix decomposition explained in Section 4.2.

## 5. Experiments

We have carried out a set of tests in order to first compare the performance of AMMA translators (using transformation rules)
with translators written by hand, and second, to show that the automatic generation of solver files does not lead to a loss of performance in terms of solving time. Tests have been performed on a 3GHz Pentium 4 with 1GB RAM running Ubuntu 6.06, and benchmarks used are the following [28]:
- Send: The cryptoarithmetic puzzle Send + More = Money. - Stable: The stable marriage problem presented. - Queens: The N-Queens problem (n=10 and n=18).

- Packing: Packing 8 squares into a square of area 25.

- Production: A production-optimization problem.

- Ineq20: 20 Linear Inequalities.

- Engine: The assembly of a car engine subject to design constraints.

- Sudoku: The Sudoku logic-based number placement puzzle.

- Golfers: To schedule a golf tournament.

| Table 1. Translation times (seconds) sC to FsC to Gecode/J FsC to ECLiPSe   |       |       |       |       |       |
|-----------------------------------------------------------------------------|-------|-------|-------|-------|-------|
| Benchmark                                                                   | FsC   | Java  | AMMA  | Java  | AMMA  |
| Send                                                                        | 0.237 | 0.052 | 0.688 | 0.048 | 0.644 |
| Stable                                                                      | 0.514 | 0.137 | 1.371 | 0.143 | 1.386 |
| 10-Queens                                                                   | 0.409 | 0.106 | 1.301 | 0.115 | 1.202 |
| 18-Queens                                                                   | 0.659 | 1.122 | 3.194 | 0.272 | 2.889 |
| Packing                                                                     | 0.333 | 0.172 | 1.224 | 0.133 | 1.246 |
| Production                                                                  | 0.288 | 0.071 | 0.887 | 0.066 | 0.783 |
| 20 Ineq.                                                                    | 0.343 | 0.072 | 0.895 | 0.072 | 0.891 |
| Engine                                                                      | 0.285 | 0.071 | 0.815 | 0.071 | 0.844 |
| Sudoku                                                                      | 3.503 | 1.290 | 4.924 | 0.386 | 4.196 |
| Golfers                                                                     | 0.380 | 0.098 | 1.166 | 0.111 | 1.136 |

Table 1 shows preliminary results comparing AMMA translators with translators written by hand (in Java). Column 3 and 4 give the translation times using Java and AMMA translators, from Flat s-COMMA (FsC) to Gecode/J and from **Flat s-COMMA** to ECLiPSe, respectively. Translation times from **s-COMMA** (sC) to