# Rewriting Constraint Models With Metamodels

Raphael Chenouard ¨
1 and **Laurent Granvilliers**1and **Ricardo Soto**1,2 1Universit´e de Nantes, LINA, CNRS UMR 6241, France 2Escuela de Ingenier´ıa Inform´atica Pontificia Universidad Cat´olica de Valpara´ıso, Chile
{raphael.chenouard,laurent.granvilliers,ricardo.soto}@univ-nantes.fr

## Abstract

An important challenge in constraint programming is to rewrite constraint models into executable programs calculating the solutions. This phase of constraint processing may require translations between constraint programming languages, transformations of constraint representations, model optimizations, and tuning of solving strategies. In this paper, we introduce a pivot metamodel describing the common features of constraint models including different kinds of constraints, statements like conditionals and loops, and other first-class elements like object classes and predicates. This metamodel is general enough to cope with the constructions of many languages, from object-oriented modeling languages to logic languages, but it is independent from them. The rewriting operations manipulate metamodel instances apart from languages. As a consequence, the rewriting operations apply whatever languages are selected and they are able to manage model semantic information. A bridge is created between the metamodel space and languages using parsing techniques. Tools from the software engineering world can be useful to implement this framework.

## Introduction

In constraint programming (CP), users describe properties of problems as constraints involving variables. The computer system calls constraint solvers to calculate the solutions. The automatic mapping from constraint models to solvers is the key issue of this paper. The goal is to develop middle software tools that are able to reformulate and rewrite models according to solving requirements.

Modeling real-world problems requires high-level languages with many constructions such as constraint definitions, programming statements, and modularity features.

In the recent past, a variety of languages has been designed for a variety of users and problem categories. On one hand, there are many modeling languages for combinatorial problems such as OPL (Van Hentenryck et al. 1999),
Essence (Frisch et al. 2007), and MiniZinc (Nethercote et al. 2007) or numerical constraint and optimization problems such as Numerica (Van Hentenryck, Michel, and Deville 1997) and Realpaver (Granvilliers and Benhamou 2006). On the Copyright c 2021, Association for the Advancement of Artificial Intelligence (www.aaai.org). All rights reserved.

other hand, constraint solving libraries have been plugged in computer programming languages, for instance ILOG
Solver (Puget 1994), Gecode (Schulte and Tack 2006), and ECLiPSe(Apt and Wallace 2007). In the following, we will only consider modeling languages as input constraint models. However, computer programming languages can be chosen as targets of the mapping process. Our aim is therefore to provide a many-to-many mapping tool that is able to cope with a variety of languages.

Many constructions are shared among the different languages, in particular the definitions of constraints. Other constructions are specific such as classes in object-oriented languages or predicates in logic languages. We propose to embed this collection of concepts in a so-called metamodel, that is a model of constraint models. This pivot metamodel describes the relations between concepts and it encodes in an abstract manner the rules for constraint modeling. This is a considerable improvement of our previous work (Chenouard, Granvilliers, and Soto 2008) which was restricted to a one-to-many mapping approach from a particular modeling language. Moreover, the translations to obtain Flat s-COMMA models were hand-coded and model structures are always flattened like for FlatZinc models (Nethercote et al. 2007). Previous model transformations were also specific to Flat s-COMMA and its structure (e.g. there is no object and no loop to manage). Our pivot metamodel is independent of modeling languages and our approach offers more flexibility in getting efficient executable models. The rewriting process can be seen as a three-steps procedure. During the first step, the user constraint model is parsed and a metamodel instance is created. During the last step, the resulting program is generated from a metamodel instance. These two steps constitute a bridge between languages - the grammar space - and models - the model space. The middle step may implement rewriting operations over metamodel instances, for instance to transform constraint representations from an integer model to a boolean model. The main interest is to manipulate concepts rather than syntactic constructions. As a consequence, the rewriting operations can be expressed with clarity and they apply whatever languages are chosen.

An interesting work is about the rule-based programming language Cadmium (Duck, Stuckey, and Brand 2006)