combining constraint handling rules (Fr¨uhwirth 2009) and term rewriting to transform constraint models. The rewriting algorithm matches rules against terms in order to derive some term normal forms. This approach provides a very clear semantics to the mapping procedure and it addresses confluence and termination issues. Considering metamodels allows one to reuse metamodeling tools from software engineering. For instance, ATL (Kurtev, van den Berg, and Jouault 2007) is a general rule-based transformation language mixing model pattern matching and imperative programs, which can be contrasted with term matching in Cadmium. Kermeta (Muller, Fleurey, and J´ez´equel 2005) is a transformation framework allowing to handle model elements using object-oriented programs. A benefit of the model-driven approach is to directly manage typed model concepts using the metamodel abstract description.

The remaining of this paper is organized as follows.

Section 2 presents the general model-driven transformation framework underlying this work. A motivating example using known CP languages is described in Section 3. The pivot metamodel and rewriting operations are presented in Section 4. Section 5 investigates some transformation experiments on well-known CP models. Finally, Section 6 concludes the paper and details some future work.

## Model Engineering Framework

A constraint model is a representation of a problem, written in a language, and having a structure. Our purpose is to transform solver-independent models to solver-dependent models. That may lead
- to change the representation of input models, namely the intrinsic constraint definitions, in order to improve the solving strategy,
- to translate languages, from high-level modeling languages to low-level solver languages or computer programming languages, and
- to modify model structures according to the capabilities of solvers, for instance to make a shift from object-oriented models to logic models based on predicates.

Managing representations supposes to specify constraint transformation rules such as the equivalence of constraint formulations or constraint relaxations. Translating languages requires to map concrete syntactic elements. Manipulating structures deals with abstract modeling concepts like objects or predicates. An important motivation is to separate these different concerns. In particular, the equivalence of constraint formulations is independent from the languages.

This argues in favour of a model technical space (MDE TS)
gathering modeling concepts and transformation rules and a grammar technical space (Grammar TS) addressing the language issues, as shown in Figure 1.

In the grammar space, models are written in languages given by grammars. In the model space, they are defined as relations between elements that conform to metamodels.

The elements are instances of concepts described in metamodels, for example a constraint x + y = z deriving from

![0_image_0.png](0_image_0.png)

some algebraic constraint concept. The relations define links between concepts such as composition and inheritance. That allows one to define complex elements, such as constraint systems composed of collections of constraints.

The shift from languages to models can be implemented by parsing techniques. Model A is created from the source user model A. This model must conform to the user language metamodel, as is required in the model space. As a consequence, metamodels of languages —
modeling languages, constraint programming languages, solver languages— must be defined. The output B is generated from model B. This model must conform to the metamodel of the solver language.

Model transformations are defined in the model space.

The goal is to transform model A reflecting the user constraint model to model B associated to the solver. As previously mentioned, that requires to change model representations and structures. This process can be done by rewriting operations manipulating concepts from A to B. In order to share common concepts, we propose to introduce the socalled pivot metamodel. The transformation chain is then a three-steps procedure: a shift from model A to the pivot model, the application of rewriting operations over the pivot model, and a shift from the pivot model to model B.

In the following (Section 4), we will present the pivot metamodels and model transformation operations. However, we will present first a motivating example (next section) and discuss the requirements for handling constraint models.

## A Motivating Example

Let us illustrate the transformation process on the social golfers problem. The user model is written in the objectoriented modeling language s-COMMA. The output is a computer program written in the constraint logic programming language ECLiPSe. This problem considers a group of n = g ×s golfers that wish to play golf each week, arranged into g groups of s golfers. The problem is to find a playing schedule for w weeks such that no two golfers play together more than once. Figure 2 and 3 show the s-COMMA model