and the ECLiPSe model for this problem, respectively.

The s-COMMA model is divided in a data file and a model file. The data file is composed by an enumeration holding the golfer names, and three constants to define the problem dimensions (size of groups, number of weeks, and groups per week). The model file is divided into three classes.

One to model the groups, one to model the weeks and one to arrange the schedule of the social golfers. The **Group**
class owns the **players** attribute corresponding to a set of golfers playing together, each golfer being identified by a name given in the enumeration from the data file. In this class, the code block called **groupSize** (lines 14 to 16) is a constraint zone (constraint zones are used to group statements such as loops, conditionals and constraints under a given name). The **groupSize** constraint zone restricts the size of the golfers group. The **Week** class has an array of Group objects and the constraint zone **playOncePerWeek**
ensures that each golfer takes part of a unique group per week. Finally, the **SocialGolfers** class has an array of Week objects and the constraint zone **differentGroups** states that each golfer never plays two times with the same golfer throughout the considered weeks.

//Data file
* [3] Dada 111a * [4] **a**um Mas := [a,b,c,d,e,f,g,h,i]; * [5] **2**. int a := 3; //raise of groups * [6] **3**. int w := 4; //number of weeks * [7] **4**. int g := 3; //groups per week

![0_image_3.png](0_image_3.png)

//Model file  l. main class SocialGolfers {  2. Weak weekSchedS[w];  3. constraint diffézentGroups {  4. forall(w1 in l..w)  5. forall(w2 in w1+l..w)  6. forall(g1 in l..g)  7. forall(w2 in l..g) {  8. caract(weekSchedS[w1].groupSched[g1].players intersect)  9. weekSchedS[w2].groupSched[g2].players) <= l;  1. 
Figure 2: An s-COMMA model of the social golfers problem.

The generated ECLiPSe model is depicted in Figure 3, which has been built as a single predicate whose body is a sequence of atoms. The sequence is made of the problem dimensions (lines 2 to 4), the list of integer sets L (lines 6 to 7), and three nested loop blocks resulting from the transformation of the three s-COMMA classes (lines 9 to 36). It turns out that parts of both models are similar. This is due to the sharing of concepts in the underlying metamodels, for instance constants, **forall** statements, or constraints. However, the syntaxes are different and specific processing may be required. For instance, the for statement of ECLiPSe needs the **param** keyword to declare parameters defined outside the current scope, e.g. the number of groups G.

1. socialGolfers(L):-

![0_image_0.png](0_image_0.png) ![0_image_1.png](0_image_1.png) 5.

6. intsets(WEEKSCHED_GROUPSCHED_PLAYERS,12,1,9),
7. L = WEEKSCHED_GROUPSCHED_PLAYERS, ![0_image_2.png](0_image_2.png)

Figure 3: The social golfers problem expressed in ECLiPSe.

The treatment of objects is more subtle since they must not participate to ECLiPSe models. Many mapping strategies may be devised, for instance mapping objects to predicates (Soto and Granvilliers 2007). Another mapping strategy is used here, which consists of removing the objectbased problem structure. Flattening the problem requires visiting the many classes through their inheritance and composition relations. A few problems to be handled are described as follows. Important impacts on the attributes may happen. For example, the **weekSched** array of **Week** objects defined at line 2 of the model file in Figure 2 is refactored and transformed to the WEEKSCHED GROUPSCHED **PLAYERS**
flat list stated at line 6 in Figure 3. It may be possible to insert new loops in order to traverse arrays of objects and to post the whole set of constraints. For instance, the last block of for loops in the ECLiPSe model (lines 28 to 36) has been built from the **playOncePerWeek** constraint zone of the sCOMMA model, but there is an additional for loop (line 28)
since the **Week** instances are contained in the **weekSched**
array. Another issue is related to lists that cannot be accessed in the same way as arrays in s-COMMA. Thus, local variables (Vi) and the well-known nth Prolog predicate are introduced in the ECLiPSe model.

## Pivot Model Handling

Our pivot metamodel has been defined to catch most modeling needs that occur in constraint modeling languages.