Then, pivot models are managed with several refining transformations, where each transformation identifies a clear refining process, namely structure modifications (e.g. removal of object variables) or model optimization.

Pivot Metamodel Figure 4 depicts an extract of our pivot structure metamodel in a simplified UML Class diagram formalism. Italic font is used to denote abstract concepts. The root concept is **Model**
which contains all entities. Three abstract concepts inherit from the abstract class **ModelElement**:
- **Classifier** represents all types than can be used to define variables or constants:
- **DataType** corresponds to common primitive data types used in CP, namely Boolean, Integer and Real.

- **Enumeration** is used to define symbolic types, i.e. a set of symbolic values defined as **EnumLiteral** (not defined here to keep the figure readable), e.g. **enum**
Name:={**a,b,**. . .}, line 1 of data file in Figure 2.

- **Class** is similar to the object-oriented concept of class, but defined in a CP context
(Soto and Granvilliers 2007), i.e. a class definition is composed of variable or constant definitions and also constraints and other statements. Thus, a **Class** has a set of features being instances of ModelFeature.

- **ModelFeature** corresponds to the instance concepts defined within a model. It is also divided in three concepts:
- **Record** relates to non-typed instances being composed of a collection of elements, such as tuples. To cover a broader range of record definitions, we define a composition of **ModelFeature** instances.

- **TypedElement** is an abstract concept corresponding to typed constraint model elements. Thus, it has a reference to a classifier. The concept of array variable is not distinguished from variable, but array can be represented using a sequence of sizes, corresponding to each dimension of an array (more than two dimensions are allowed). Theses sizes are expressed as **Expression** instances.

∗ **Variable** has an optional **Domain** definition (not shown here) restricting values belonging to the associated type. Three concepts of **Domain** are taken into account: intervals, sets and domains defined as an expression.

∗ **Constant** concept is for constants having a type and a fixed value.

- **Statement** is used to represent all the other features that may occur in a **Model** or a **Class**:
∗ **Constraint** is the abstract constraint concept having two sub-concepts. **ExpressionConstraint** stands for constraints built inductively from terms and relations. **GlobalCtr** handles global constraints defined by a name and a list of parameters.

∗ **ForAll** defines a loop mechanism over constraints and other statements. It has an iterating variable which is local to the loop.

∗ If obviously defines a conditional statement. It is composed of an **Expression** corresponding to the boolean test and two sets of statements corresponding to the statements to take into account according to the test evaluation. The second set of statements is optional if no alternative to the true evaluation of the test is defined.

- **ParameterizedElement** defines concepts having a list of parameters and not being a classifier neither an instance of a **ModelFeature**:
- **Predicate** represents logical predicates in a model as in ECLiPSe. Predicates have parameters and a body composed of a sequence of **ModelFeature**, such as variable definitions or constraint statements.

- **Function** represents user-defined functions stated in a model. It contains also a body, but it is based on a statement used to compute a result.

The notion of expression is ubiquitous in CP. The related concepts of our metamodel are detailed in Figure 5. They represent all the entities occurring in first-order formulas made from variables, terms, relations, and connectives. The concept **Expression** is abstract and is used as super class for all kinds of expressions:
- **FunctionCall** is used to refer to an already defined Function and contains a list of parameters defined as Expression.

- **VarOccurrence** is used to refer to already defined instances: records, variables or constants. It is only composed of a reference to the corresponding instance declaration and to a list of optional indexes to handle arrays. It is specialized in **ObjectOccurrence** in order to express the navigation path to an object attribute (e.g.

groupSched[g1].players, line 8 in Figure 2). Variable occurrences are not classified according to their declaration type in one of the three expression types inheriting from **Expression** in order to avoid multiple declaration of the same concept, while requiring type inference mechanism.

- **BooleanExpression** is used to specify boolean concepts occurring in expressions:
- **BoolValue** represents the terms **true** and **False**.

- **PredicateCall** corresponds to the call of a predicate with its list of parameters. Thus, it is composed of a reference to a **Predicate** with a list of parameters defined as **Expression** in order to allow at the same time VarOccurrence and evaluable expressions, such as 1, x or x + 1.

- **BoolOperator** is an abstract concept having a name representing the symbol of well-known operators. It is specialized in the two common types of operators:
∗ **BoolUnaryOp** corresponds to the negation operator and has an operand corresponding to an **Expression**,
since it can be a boolean expression, but also a variable. In the following, operands of all operators will be defined as a composition of **Expression**.