Alldifferent removal Since global constraints are not handled by every solver, there is a motivation to reformulate them or to generate relaxations. We consider here, the wellknown global constraint alldifferent(x1**, ..., x**n). We assume that the domain of each xi varies from 1 to n to ease the definition of the two last algorithms. We propose three possible transformations:
- Generating a set of disequalities as shown in Algorithm 2.

For all variable combinations (line 2,3), a constraint is generated and added to the result (line 6).

Algorithm 2 Transforming alldifferent to a set of disequalities AllDiffToDisequalities(c : **GlobalConstraint**) : Set of **Constraint**
1: let res : Set of **Constraint** = ∅
2: **for all** i in 1..c.parameters.size() do 3: **for all** j in i + 1..c.parameters.size() do 4: let x : **Variable** = c.parameter[i]
5: let y : **Variable** = c.parameter[j]
6: res.insert(new **Constraint**(x 6= y))
7: **end for** 8: **end for** 9: **return** res
- Generating a relaxation as shown on Algorithm 3. Only one constraint is created (line 3) assessing that the sum of all variable values is equal to n(n + 1)/2.

## Algorithm 3 Generating Alldifferent Relaxations Alldifftorelaxation(C : **Globalconstraint**)

: **Constraint**
1: let n : Integer = c.parameters.size()
2: let sum : **Expression** =Pn i=1 c.parameters[i]
3: return new **Constraint**(sum = n(n+1)/2)

- Generating a boolean version as shown on Algorithm 4.

In this case, we define a new matrix of boolean variables
(line 2,3,4), where b[**i, j**] being true means xi has value j.

Line 7 checks that only one value per variable is defined.

Line 10 ensures that two variables have different values.

## Experiments

The presented architecture has been implemented with three tools and languages: KM3 (Jouault and B´ezivin 2006) is a metamodel language, ATL (Kurtev, van den Berg, and Jouault 2007) is a declarative rule language to describe model transformations and TCS (Jouault, B´ezivin, and Kurtev 2006) is a declarative language based on templates to define the text to model and model to text transitions. These MDE tools allow us to choose the refactoring steps to apply on pivot models in order to keep supported structures of the target metamodel.

We have carried out a set of tests in order to analyze the performance of our approach. We used five CP problems: Social Golfers, Engine Design, Send+More=Money, Algorithm 4 Reformulating alldifferent into a boolean model AllDiffToBoolean(c : **GlobalConstraint**) : Set of **ModelFeature**
1: let res : Set of **Constraint** = ∅
2: let n : Integer = c.parameters.size()
3: let m : Integer = card(c.parameters.domain) 4: let b[n,m] : Boolean 5: res.insert(b)
6: for i in 1..n do 7: res.insert(new **Constraint**(Pm j=1 b[i,j] = 1))
8: **end for**
9: for j in 1..m do 10: res.insert(new **Constraint**(Pn i=1 b[i,j] = 1))
11: **end for**
Stable Marriage and N-Queens. The first experiment evaluates the performance in terms of translation time, and the second one was done to show that the automatic generation of solver files does not lead to a loss of performance in terms of solving time. The benchmarking study was performed on a 2.66Ghz computer with 2GB RAM running Ubuntu.

| Problems   | sC   | s-to-P   | Object   | Enum   | P-to-E   | Total   | Ecl   |
|------------|------|----------|----------|--------|----------|---------|-------|
| Lines      | (s)  | (s)      | (s)      | (s)    | (s)      | Lines   |       |
| Golfers    | 31   | 0.276    | 0.340    | 0.080  | 0.075    | 0.771   | 37    |
| Engine     | 112  | 0.292    | 0.641    | 0.146  | 0.087    | 1.166   | 78    |
| Send       | 16   | 0.289    | 0.273    | -      | 0.089    | 0.651   | 21    |
| Marriage   | 46   | 0.330    | 0.469    | 0.085  | 0.067    | 0.951   | 26    |
| 10-Q       | 14   | 0.279    | 0.252    | -      | 0.033    | 0.564   | 12    |

Table 1: Times for complete transformation chains of several classical problems.

In the first experiment we test the s-COMMA (sC) to ECLiPSe(Ecl) translation. Table 1 depicts the results. The first column gives the problem names. The second column shows the number of lines of the s-COMMA source files.

The following columns correspond to the time of atomic steps involved in the transformation (in seconds): transformations from s-COMMA to Pivot (s-to-P) (corresponds to Source Text A to Model Pivot in Figure 1), object flattening (Object), enumeration removal (Enum), and transformations from Pivot to ECLiPSe(P-to-E) (corresponds to Model Pivot to Target Text B in Figure 1). The next column details the total time of the complete transformation, and the last column depicts the number of lines of the generated ECLiPSe files.

The results show that the text processing phases (s-toP and P-to-E) are fast, but we may remark that the given problems are concisely stated (maximum of 112 lines). The transformation s-COMMA to pivot is slower than the transformation pivot to ECLiPSe. This is explained by the refactoring phases performed on the pivot that reduce the number of elements to handle the pivot to ECLiPSestep. The composition flattening is the more expensive phase. In particular, the Engine problem exhibits the slowest running time,