transformation to ECLiPSe **model. It can be explained by the refactoring phases**
on the pivot model which simplify and reduce the data to process. We **see that** the composition flattening step is the more expensive. In particular, the Engine problem exhibits the slowest running time, since it corresponds to the design of an engine with more object compositions.

| Problems                                     | Inject s-to-P Comp Forall   | P-to-E Extract   | Total   | Lines Total/Lines   |        |        |        |     |
|----------------------------------------------|-----------------------------|------------------|---------|---------------------|--------|--------|--------|-----|
| (s)                                          | (s)                         | (s)              | (s)     | (s)                 | (s)    | (s)    | (-)    | (-) |
| 5-Queens                                     | 0.132 0.147 0.252           | 0.503            | 0.071   | 0.019               | 1.124  | 80     | ≈0.014 |     |
| 10-Queens                                    | 0.132 0.147 0.252           | 1.576            | 0.280   | 0.060               | 2.447  | 305    | ≈0.008 |     |
| 15-Queens                                    | 0.132 0.147 0.252           | 3.404            | 0.659   | 0.110               | 4.704  | 680    | ≈0.007 |     |
| 20-Queens                                    | 0.132 0.147 0.252           | 6.274            | 1.224   | 0.178               | 8.207  | 1205   | ≈0.006 |     |
| 50-Queens                                    | 0.132 0.147 0.252 32.815    | 13.712           | 1.108   | 48.166              | 7505   | ≈0.006 |        |     |
| 75-Queens                                    | 0.132 0.147 0.252 80.504    | 54.286           | 2.456   | 137.777 16880       | ≈0.008 |        |        |     |
| 100-Queens 0.132 0.147 0.252 175.487 126.607 | 4.404                       | 307.029 30005    | ≈0.010  |                     |        |        |        |     |

Table 2. **Time of complete transformation chains of the N-Queens problem.**
Table 2 presents seven different sizes of the N-Queens problem where the loop unrolling step has been applied. This experiment allows us to check the scalability of our approach according to model sizes. It can be analyzed through the ratio given in the last column which aims at quantifying the efficiency **of a** transformation chain considering the execution time per generated lines.

As shown on this table, the ratio first decreases, but after 50-Queens it slowly grows up. In fact, the first four row ratios are impacted by the steps before the loop unrolling process, but for the last three rows they become **neglectible** comparing to the whole execution time. It may be noticed that for big **problems** (after 50-Queens) the ratio smoothly increases. We can thus conclude that our approach is applicable even for huge models, although translations times are not the major concerns in CP.

## 7 Conclusion And Future Work

In this paper, we propose a new framework for constraint model transformations. This framework is supported by a set of MDE tools that allow an easy design of translators to be used in the whole transformation chain. This chain is composed by three main steps: from the source to the pivot model, refining of the pivot model and from the pivot model to the target. The hard transformation work (refactoring/optimization) is always performed by the pivot which provide reusable and flexible transformations. The transformations from/to pivot become simple, thus facilitating the integration of new language transformations.

In this paper, only two languages are presented, but translation processes with Gecode and Realpaver [9] are already implemented.

In a near future, we intend to increase the number of CP languages **our approach supports. We also want to define more pivot refactoring transformations**
to optimize and restructure models. Another major outline for future work is to