MiniZinc [13] is intended to be a standard modeling language, and Cadmium [3]
is able to map MiniZinc models to a set of solvers. Essence [5] is another CP platform offering an high level modeling language refining Essence specifications to Essence' models using Conjure [6]. Then hand-written translators can generate models for several different solvers. The role of a mapping tool **is to bridge**
modeling and solver languages and to optimize models for improving the **solving process. Cadmium is based on Constraint Handling Rules [8] and is the the**
closest CP platform from our model-driven approach.

In our approach, we suppose that any CP language can be chosen at the modeling phase. In fact, finding a standard language is hard and existing languages have their own features. It then becomes necessary to define mappings between any (pure modeling or solver) languages. This is just the first goal of the new architecture for constraint model transformations defined in the sequel. It follows many advantages:

- **Any user may choose its favourite modeling language and the known best**
solving technology for a given problem provided that the transformation between languages is implemented.

- **It may be easy to create a collection of benchmarks for a given language**
from different source languages. This feature may speed up prototyping of one solver, avoiding hand rewriting of problems into the solver language.

- **A given problem may be handled using different solving technologies. Users**
may not have to play with solver languages.
To this end, we define a generic and flexible pivot model (i.e. an intermediate model) to which any language is mapped. Considering a new language in this framework only requires a parser and a generally simple transformation to the pivot model.

The second goal is to define refactoring operations and optimizations of constraint models using declarative rules. Implementing them over pivot **models**
guarantees the independence from external languages. In other words every operation is implemented once, by means of a so-called concept-oriented rule. In our model engineering approach the elements of models are specified within metamodels, which can be seen as a hierarchy of concepts or types. The **rules are**
able to filter models according to these types, which may be more powerful than syntax-oriented rules.

The third goal is to apply the best transformations for given solving technologies. For instance, a matrix with a few non null elements could be transformed into a sparse matrix when using a linear algebra package. The **selection of**
transformation steps is implemented as a sequential procedure, applying transformations until at least pivot models fit the structure requirements of the target language.

This architecture has been fully implemented using a model-driven engineering (MDE) approach [14]. MDE tools enable us to separate the grammar concerns from modeling concepts using dedicated tools and languages like TCS [11]
and ATL [12, 10]. The main advantage is that we can reason about concepts and