Figure 5 depicts the ECLiPSe **model resulting from an automatic transformation of the previous** s-COMMA **model. The problem is now encoded as a single**
predicate whose body is a sequence of atoms. The sequence is made of the problem dimensions, the list of constrained variables L**, and three statements resulting**
from the transformation of the three s-COMMA **classes. It turns out that parts**
of both models are similar. This is due to the sharing of concepts in the **underlying metamodels, for instance constants,** forall **statements, or constraints.**
However, the syntaxes are different and specific processing may be required. For instance, the forall statement of ECLiPSe **needs the** param **keyword to declare** parameters defined outside of the current scope, e.g. the number of groups G.

The treatment of objects is more subtle since they must not participate to ECLiPSe **models. Many mapping strategies may be devised, for instance mapping objects to predicates [16]. Another mapping strategy is used here, which**
consists in removing the object-based problem structure. Flattening the problem requires visiting the many classes through their inheritance and composition relations. A few problems to be handled are described as follows. **Important changes on the attributes may be noticed. For example, the** weeks **array of**
Week **objects defined at line 9 in Figure 4 is refactored and transformed to the** WEEKS GROUPS PLAYERS **flat list stated at line 5 in Figure 5. It may be possible to** insert new loops in order to traverse arrays of objects and to post the whole set of constraints. For instance, the last block of for loops in the ECLiPSe **model**
(lines 27 to 39) has been built from the playOncePerWeek **constraint zone of the**
s-COMMA **model, but there is two additional for loops (lines 21 and 22) since the**
Week **instances are contained in the** weeks **array. Another issue is related to lists**
that cannot be accessed in the same way than arrays in s-COMMA**. Thus, local**
variables (Vi**) and the well-known** nth **Prolog built-in function are introduced in**
the ECLiPSe **model.**

## 4 Pivot Metamodel And Refactoring Rules

The pivot model of a constraint problem is an intermediate model to be transformed by rules. The rules may be chained to implement complex transformations. In the following, the pivot and some structural refactoring **and optimization rules are presented.**

## 4.1 Pivot Metamodel

Our pivot model has been designed to support as much as possible the constructs present in CP languages, for instance variables of many types, data structures such as arrays, record, classes, first-order constraints, common global constraints, and control statements. We believe that it is better and simpler to establish a general CP metamodel, while it is more complex to find a standard CP concrete syntax.

Figure 6 depicts the metamodel associated to pivot models. A pivot model is composed of a collection of elements, divided in three main concepts: types,