Proceedings of the 9th WSEAS International Conference on Artificial Intelligence, Knowledge Engineering and Data Bases (AIKED), University of Cambridge, UK, 2010, edited by L. A. Zadeh et al, pp 191 - 195 was that the weakest attribute makes a noticeable contribution to the learning results. It is important for clinical practice to reduce the number of screening tests required for making reliable decisions. In our experiments we used the UK
Trauma data to test the efficiency of the proposed strategy and then found that it enables to reduce the number of screening tests, keeping the performance and reliability of making decisions high. In this paper we aim to further explore this strategy being applied to the problem of EEG assessment of newborn brain maturity. The paper is structured as follows. Section 2 states the problem in Bayesian assessment of newborn EEG maturity. Section 3 describes the bases of BMA over DTs, and section 4 describes the EEG data used for the experiments. The experimental results are presented in section 5, and section 6 concludes the paper.

## 2 Problem Statement

The newborn brain maturity can be estimated by experts from sleep EEG in terms of postconceptional age measured in weeks. The accuracy of such assessment is typically two weeks. We aim to develop a BMA technique to assess the brain maturity from sleep EEGs which are typically recorded via the standard C3-C4 electrode system.

These recordings were transformed into the standard frequency bands listed in Table 1. The spectral features along with their statistical characteristics form a multidimensional representation of the EEG data. The spectral features are presented by the absolute and relative spectral powers calculated for electrodes C3, C4, and their sum. Additionally the statistical variances are calculated for these features, so that the total number of EEG attributes becomes 72. No other information about the data is available to make assumptions on EEG feature importance.

 Under these conditions the standard BMA
techniques being used for assessment of the EEG
maturity cannot ensure unbiased results. This mainly happens because the detailed exploration of a multidimensional model space becomes problematic within a reasonable time. The detailed exploration is needed to ensure that the majority of models are sampled from areas of maximal posterior. Otherwise, instead of exploring all possible areas of maximal posterior, the models will be disproportionally sampled from some of these areas. The negative effect of disproportional sampling of models is that results of BMA become biased.

 Obviously, information about feature importance can reduce a model parameter space that needs to be explored. However in our case, we have no such information, and therefore we are forced to make an unrealistic assumption that all the EEG attributes make an equal contribution the age assessment. Fortunately, DT models provide the feature selection, and the use of Bayesian averaging over such models gives a posterior information about feature importance. This means that if a feature is rarely used in the models, then we conclude that this attribute makes a weak contribution and should be deleted.

 Clearly, when there are few weak attributes, the portion of models using such attributes is small, and their impact on the outcome is negligible. On the contrary, when the number of weak attributes is large, the disproportion in models becomes significant. Therefore we could improve the BMA results by reducing the disproportional sampling. In this research we aim to explore whether discarding the models using weak EEG attributes will reduce the bias in the assessment of brain maturity.

 A trivial strategy of using the posterior information for feature selection within BMA is to use this information to learn a new ensemble from a data set in which the weak attributes were deleted.

This strategy reduces a model parameter space, and therefore it enables to explore this space in more detail. The other strategy that can be thought of is refining the ensemble by discarding models which use weak attributes. We expect that such refinement can improve the BMA performance.

## 3 Implementation

For a DT given with parameters T, the predictive distribution is written as an integral over the parameters T.

## ( | , ) ( | , , ) ( | ) ,

³

## 

T

## P Y X D P Y X Ș D P Ș D Dș

$$\bigsqcup P\cup P$$

where y is the predicted class (1, …, C), x = (x1, …,
xm) is the m-dimensional vector of input, and D are the given training data. This integral can be analytically calculated only in simple cases, and in practice part of the integrand, which is the posterior density of T conditioned on the data D, p(T | D), cannot usually be evaluated.

However, for T(1), …, T(N) are the samples drawn from the posterior distribution p(T | D), we can write.