
## 5. Design Methodology In Cacs

A specific methodology was designed to allow the user to develop distributed multi-agenty systems using Swarm Intelligence paradigm and CACS approach. In general this methodology consists of the following steps:
1. Identify the key actors of the problem (VAgents). 

These actors are the entities of the system modeled.

2. Determine the properties (variables) of these actors that are restricted by constraints with properties of other actors.

3. Determine all the constraints of the problem. 4. Classify constraints logically in separate groups. 5. Specify a set of Controller Agents to monitor each group of constraints.

To provide a developer with flexible practical methods of the design we offer two refinements of the general methodology: simple and complex.

To prove the proposed methods of constraints satisfaction based on two types of the agents we developed an objectoriented CACS software prototype which can be considered as a generic framework for distributed model-driven DSSs. As we can see from Figure 5, the developed CACS prototype uses hierarchical multiple-layer architecture. The following steps correspond to a given DCSP: 
6. Creation of the problem P. This is done by creating an instance of the class DCSP from the package dcsp. 

7. Creation of agents to control variables (specifically, their references) via the prolem P. using the method makeVAgent () to create a variable and method makeCAgent () to create a controller. 3) Creating variables distributed via agents which own variables. This is done through the method makeBoundedIntVar () which creates a variable with two upper and lower limits. 

8. Creation of constraints on variables. 9. Addition of constraints to CAgents. 10. Start the algorithm of resolution through the DCSP P.

The use of the prototype can be demonstrated via the following simple example: V = {x, y, z} is the set of variables from the domain {1, …, 100} 
for all of them, C = {c1, c2, c3} is the set of constraints:
c1: x ≠ *y, y* ≠ z, x ≠ z (or alldifferent (x, y, z))
c2: x ≥ y c3: z ≥ y In order to model this problem using the proposed prototype the user should proceed as follows. We start by assigning variables to VAgents. In this example, agents v1, v2, and v3 own variables x, y, and z respectively. Note that the distribution of variables may be a problem dependant issue which means that the user chooses the owner agent of each variable according to the problem specifications. In the same manner, constraints also should be assigned to CAgents. In this example, we assign each constraint to a CAgent. 1. Create a distributed problem p (an instance of DCSP class). 

This class will be used in order to create VAgents and CAgents and to start our CACS algorithm.

DCSP p = new DCSP("example"); This creates a distributed problem with which agents, variables and constraints will be created.

2. Use this instance to create both types of agents. This is done by calling makeVAgent() and makeCAgent() methods from the DCSP instance created in step 1 as follows:
VAgentRef v1 = p.makeVAgent ("v1"); VAgentRef v2 = p.makeVAgent ("v2"); VAgentRef v3 = p.makeVAgent ("v3"); CAgentRef c1 = p.makeCAgent ("c1"); CAgentRef c2 = p.makeCAgent ("c2"); CAgentRef c3 = p.makeCAgent ("c3"); 3. Create variables inside VAgents. In other word, assign variables to variables agents. The method makeBoundedIntVar() is used to achieve this as follows:
VID x = v1.makeBoundedIntVar ("x", 1, 100); VID y = v2.makeBoundedIntVar ("y", 1, 100);
VID z = v3.makeBoundedIntVar ("z", 1, 100);
4. Create the constraints and post them to CAgents. The constraints are created separately and posted to their owner agents using the method post():
c1.post(new AllDifferent(new VID[]{x,y,z})); c2.post(new GreaterOrEqual(x, y)); c3.post(new GreaterOrEqual (y, z)); 5. Start the CACS algorithm by calling solve() method from 

## The Dcsp Instance:

p.solve();
This last instruction initiates communication between the different agents in the system in accordance the algorithm described previously in Section 3. If an agent finds a value for its variable that corresponds to a solution then it will notify to this value. The solution will be the combination of all values from all agents. Otherwise, no-solution state is declared.

Also the developer can express the structure of DCSP in declarative manner using XML. For instance, the problem described in previous sub-section can be written in XML as follows: <?xml version="1.0" encoding="UTF-8"?> <!DOCTYPE dcsp SYSTEM "dcsp.dtd"> <dcsp> <name>example</name> <vagent><name>v1</name><var><name>x</name> <inf>1</inf><sup>100</sup></var></vagent> v2 and v3 by the same manner <cagent> <name>c1</name> <constraint><alldiff> <vid><name>x</name><owner>v1</owner></vid> <vid><name>y</name><owner>v2</owner></vid> <vid><name>z</name><owner>v3</owner></vid> </alldiff></constraint></cagent> c2 and c3 by the same manner </dcsp>