
## 6. Cacs Approach In Transport Logistics

We consider modern transportation problems as a natural candidate domain for evaluation of the proposed CACS 
approach. Although there is a lot of different centralized algorithms in this area we believe that multi-agent techniques can radically improve efficiency and fairness of negotiation between participants in the course of problem solving as well as improve reactivity of the logistics systems. Among different benefits of logistics management within the CACS framework we can point out such positive features as: better consideration of individual preferences and ability of their dynamical changes in the course of solving, early availability of partial solutions and inherently distributed structure of the system.

In order to create solid foundations for application of Swarm Intelligence and CACS approach in transportation logistics we developed a distributed multi-agent application which mimics major features of modern ship loading problems, and evaluated its feasibility and performance. Our CACS application is based on a simplified ship loading scenario which was originally presented in studied in Chips constraint solver by Kay Chips (Kay 1997) and later was expressed in terms of Java-based Choco constraint solver by prof. A. Aggoun.

![0_image_0.png](0_image_0.png)

Figure 13. Graphical representation of the original Kay's ship loading problem (Kay 1997)
In the discussed problem a specific precedence function *pred* in 

![0_image_2.png](0_image_2.png) defined over the loading items. For each of the items the number of workers needed for loading is specified.

Figure 14. The feasible order of loading tasks (the loading plan) 
in accordance with the constraints given (Kay 1997)
According to CACS methodology each loading task is realized as a separate Variable Agent in our CACS application. Variable Agent holds three specific variables. These variables determine start time of loading (t i start), finish time of loading 
(t i end) and predetermined loading duration (d i) accordingly.

All constraints of the considered problem are grouped inside Controller Agents. We recognize three different groups of Controller Agents according to the semantics of the constraints. The first group contains Controller Agents which hold duration constraints. The agent of that group is responsible for verifying that the loading tasks are scheduled within the time frame. It means that for each task i the following constraint should be satisfied: t i start + d it i end. 

The second group contains Controller Agents which are responsible for verifying that the loading plan satisfies precedence constraints given (like one on the fig. 13). Finally the third group contains Controller Agents which are responsible for verifying availability of the resources for the loading plan. Controller Agent of that kind holds cumulative constraint over the number of workers available for finishing the ship loading within the total time.

That cumulative constraint may be expressed using current values of t i start, and t i end variables, as well predetermined workforce effort needed for each task w i. Given these values we can define the scheduling matrix SC.

$$\text{SC}=\left[\begin{array}{cccccccccccc}0&0&w^{1}&w^{1}&w^{1}&0&0&...&0\\ 0&0&0&w^{2}&w^{2}&0&0&...&0\\ &&&&&&&&\\ 0&0&0&0&0&0&...&w^{N}&w^{N}\\ &&&&&&&&\\ 0&0&0&0&0&0&...&w^{N}&w^{N}\\ \end{array}\right]$$  The element $SC_{ij}$ is equal to $w_{j}$ iff at the time moment $j$ the 

loading task i is performed, and it is equal to 0 in the opposite case.

Using that matrix we may define the maximum number of workers needed at each moment of the time and the needed cumulative constraint:SC Persons

$$\mathrm{\boldmath~\oint~}\operatorname*{max}_{j}\quad\left(\sum_{i=1}^{N}S C_{i j}\right)\leq\operatorname*{max}P e r s o n s\ t$$
.
With such problem interpretation we may completely describe it in terms of our CACS approach. The original structure of the agents is presented on Figure 15.

![0_image_1.png](0_image_1.png)

