# Automatically Discovering Hidden Transformation Chaining Constraints

Raphaël Chenouard1 **and Frédéric Jouault**2 1 **LINA, CNRS, Université de Nantes, France**
2 **AtlanMod (INRIA & EMN), France**
raphael.chenouard@univ-nantes.fr, frederic.jouault@inria.fr Abstract. **Model transformations operate on models conforming to precisely defined metamodels. Consequently, it often seems relatively easy**
to chain them: the output of a transformation may be given as input to a second one if metamodels match. However, this simple rule has some obvious limitations. For instance, a transformation may only use a subset of a metamodel. Therefore, chaining transformations appropriately requires more information.

We present here an approach that automatically discovers more detailed information about actual chaining constraints by statically analyzing transformations. The objective is to provide developers who decide to chain transformations with more data on which to base their choices. This approach has been successfully applied to the case of a library of endogenous transformations. They all have the same source and target metamodel but have some hidden chaining constraints. In such a case, the simple metamodel matching rule given above does not provide any useful information.

## 1 Introduction

One of the main objectives of Model-Driven Engineering (MDE) is to automatize software engineering tasks such as: the production of code from abstract models in forward engineering scenarios, the production of abstract models from code in reverse engineering scenarios, or a combination of the two previous cases in modernization scenarios. To achieve this automation, MDE relies on precisely defined models that can be processed by a computer. Each model **conforms to a** metamodel that defines concepts as well as relations between **them. For instance,**
a Java metamodel has the concept of Java class, with the corresponding singlevalued superclass relation (i.e., a class can only extend one other class). Similarly, the UML metamodel defines the concept of a UML class, with a multi-valued generalization relation (i.e., a class may extend several other classes). Many software engineering tasks such as those mentioned above can be performed by model transformations.

In order to reduce the effort of writing these transformations, complex tasks are generally not performed by complex transformations but **rather by chains** of simpler transformations. A model transformation chain is formed by feeding