
## 4 Experiments 4.1 Application To The Motivating Example

In the motivating example presented in Section 2 (see Figure **2), we consider five** endogenous transformations achieving the following reformulation tasks:
- Class and objects removal. **This complex endogenous transformation is**
decomposed in two steps. The first step removes classes and does not copy their features. Variables with a class type are mutated in an **untyped record** definition that is a duplication of the class features. Other **variables - with** a primitive type like integer, real or boolean - are simply copied like other elements not being contained in a class declaration. The second step flattens record elements to get only variables with a primitive type.

- Enumeration removal. **Some CP solvers do not accept symbolic domains.**
Thus, variables with a type being an enumeration are replaced by integer variables with a domain ranging from 1 to the possible number **of symbolic** values.

- Useless If removal. **Boolean expressions used as tests in conditional if**
statements can be constant. In this case, it can be simplified, by removing conditional if elements and keeping only the relevant collection of statements.

- For loops removal. **This reformulation task is implemented as a fixed**
point transformation followed by the useless if removal transformation. In the fixed point, each step removes only the deepest loops, i.e. loops that do not contain other loops. To ease the loops removing task, this composite element is replaced by another composite one being a conditional statement with an always true boolean test (i.e., a block).

We have applied on this example the HOT presented in the previous section.

The results are detailed in the two following tables, which were automatically generated.

First, Table 2 presents the names of ignored in and out concrete concepts for each analysed transformation. These concepts are defined as concrete in the pivot metamodel, but they do not appear in any OCL expression **of transformations. We can see, there is only one in ignored concept considering the record**
removal step. Indeed, this transformation was written with **the assumption of**
being launched after the class instantiation transformation. Looking at the generated models, several concepts are missing, such as Class and Record for the record removal transformation.

Second, Table 3 gives more details on what endogenous transformations really do. Each line corresponds to an endogenous transformation analysis. Each column details the characteritics - always, conditionally **and lazily - of none,** one, several, or all other concepts. These characteristics **are detailed for copy**
and mutation rules.

## 4.2 Interpreting The Results

Typing source and target models. **The results given by Table 2 can be used**
to finely type authorized source and target models of the transformation. The