concepts may be only copied. This pattern may allow us to detect whether an endogenous transformation could be applied in a fixed point scheme. In Tables 2 and 3 we see that the forall removal transformation matches this pattern. Looking only at Table 3, we may think that the enumeration removal **transformation is also a fixed point transformation processing variables. However, Table 2**
shows that its main goal is to remove enumerations, because its domain and its codomain are not equal (i.e., it removes all enumerations in **one step).**

## 5 Discussions 5.1 Application To Exogenous Transformations

The approach presented in this paper could be extended to support exogenous transformations. Thus, looking at the source patterns and all OCL expressions, we can define the refined type of source models of a transformation (i.e., a more precise definition of its domain). To get the refined type of target models (i.e., a more precise definition of the codomain), we just have to collect the set of concepts occurring in target patterns.

Moreover, we can consider most endogenous transformations **as exogenous**
transformations between two sub-metamodels of the same metamodel. Then, the chaining of endogenous transformations can be transformed into a problem of chaining exogenous transformations. Inferring the meaning of an endogenous transformation may not be necessary (in most cases), since its main task may be to remove or add elements of a given type. However, more complex endogenous transformations may be more difficult to finely chained, since **their meaning is**
necessary to understand how to use them. The knowledge collected in Table 3 is an attempt at achieving this goal with high-level characteristics on concepts. However, this knowledge does not focus on how matchings are performed in rules. Using a more detailed analysis, we could generate weaving models relating to model transformations and then analyze them. However, these models would be more verbose than Table 3. We could also try to analyse OCL expressions and mappings in transformation rules. Although, the cost and the difficulty of our approach is almost negligible when compared to these deeper analysis.

## 5.2 Debugging Transformations

The knowledge discovered through our analysis transformation can be used in debugging model transformations (exogenous or endogenous). Indeed, when a metamodel contains many concepts, a software engineer may forget to define all the corresponding rules. Thus the results from Table 2 can be directly used, but also the column of Table 3 that corresponds to elements never copied and never mutated. Other columns may also be useful to check that **concepts are** well classified and no copy or mutation rule are missing.

The data in Table 3 can also be used to discover mistakes in naming metamodel concepts in some rules or helpers. Indeed, some concepts of a metamodel