may rarely have instances in models, and rules dealing with them may not be called. Thus, no error occurs even if the transformation contains some careless mistakes. In the case of our motivating example, we discovered several ill-written rules and helpers dealing with specific CP concepts that do not occur in our CP models.

## 6 Conclusion

In this paper, we addressed the problem of chaining model transformations. This problem is illustrated on a pivot metamodel for Constraint Programming (CP) that is used for translations between CP languages. Several **issues are tackled** in order to safely chain transformations. Thus, a higher-order transformation is proposed to statically analyze model transformations. It focuses on source and target concepts, thus defining refined metamodels to which models conform (i.e.,
more precise definitions of domains and codomains of model transformations).

It also extracts some knowledge on how source concepts are processed and assigns characteristics to each concept: always copied, conditionally copied, lazily copied, never copied, always mutated, etc. Considering these characteristics, we are able to find element types that are mainly processed. This **process is not** accurate enough to exactly infer the meaning of model transformations (it is an abstraction), but it allows us to assert some constraints on **how to chain several** endogenous transformations. The contributions of this paper are of a different nature and complementary to the results presented in [21]. That paper focuses on a type system for transformation chains, and considers that declared types are good enough, whereas in this paper we have investigated the problem of imprecise transformation typing.

A possible extension of the work presented in this paper would be to go beyond the discovery of hidden chaining constraints and to fully automatize transformation chaining. This automation process could be performed using Artificial Intelligence techniques. An optimization problem **can be defined to transform models from a source metamodel to another. The problem naturally comes**
to find a path in a graph corresponding to a model of the transformations and their types. Some heuristics can be defined to choose the best **paths, which may**
contain as few redundant and as few useless steps as possible.

## References
