the output of a first transformation as input to second one. Complex chains can consist of a large number of transformations. For instance, **in order to analyze a** Java model with a Petri net tool, a first transformation may operate from Java to UML, and a second one from UML to Petri net.

Model transformations are reusable. In our previous example, if a different target formalism is to be used, the Java to UML transformation may be reused, while the second one is replaced. Some model transformation **libraries such as [1]** are already available to leverage this possibility. Typically, each entry specifies the name of the transformation as well as its source and target metamodels.

Some documentation may also be available. A model-driven engineer confronted to a model transformation problem may first lookup for existing transformations. If no pre-existing transformation exactly performs the required task, some pieces may be used to form a chain into which only simpler new transformations need to be inserted. Source and target metamodel information may **be used to chain** transformations. A transformation from B to C may for instance be attached at the output of a transformation from A to B.

However, chaining transformations properly is generally a **more complex task**
in practice. Knowing the source and target metamodels of a transformation is not enough. For instance, a transformation may only target a subset of its declared target metamodel. Feeding its output to a second transformation that takes a different subset of the same metamodel as input will typically not yield correct results. Computing a class dependency graph from a Java model by reusing a transformation that takes UML Class diagrams as input may not be possible with the Java to UML transformation targeting Petri nets used in the previous example. While this new transformation requires the class structure to be retrieved from the Java model, the initial transformation may have been limited to the generation of the Activity diagrams required **for the generation of** Petri nets.

The case of endogenous transformations is even more problematic. Because these transformations have the same source and target metamodel, they can in theory be inserted in a chain anywhere this metamodel appears. A collection of such transformations operating on the same metamodel could **also be chained** in any order. In practice, this may not lead to correct results (e.g., because a transformation may remove an element from the model that is **required for** another transformation to perform correctly).

Chaining transformations actually requires more precise knowledge about the individual transformations. For instance, if transformation t1 **relies on some**
information that is dropped by transformation t2 then t1 **cannot be applied after** t2**. This knowledge may be available in a documentation of some sort, but this is**
not always the case. One may also look at the insides of a transformation (i.e., its implementation), but this requires knowledge of the transformation language (there are several languages, and not everybody is an expert **in all of them).**
The situation would be simplified if each transformation clearly identified the subset of a metamodel it considers. But this is not always enough. For instance, some endogenous transformations have a fixed point execution semantics (i.e.,