they need to be executed again and again until the resulting model is not changed any more). In such a case, the metamodel subset generated by each iteration may be different (especially the last iteration when compared to **the previous ones**
for transformations that remove elements one at a time).

The purpose of the work presented here is to automatically discover information about what model transformations actually do. The resulting data may be used to help the engineer decide how to chain transformations, and may complement what is in the documentation of the transformation if there is one. A
Higher-Order Transformation [19] that takes as input the transformations to analyze produces a model containing the analysis results. This model may then be rendered to various surfaces using other transformations.

We have applied this approach to the case of a set of endogenous transformations that are used for the translation between constraint programming languages. All transformations take the same pivot metamodel as source and target metamodel and are written in ATL [12,11,9] (AtlanMod **Transformation** Language). However, different subsets of this metamodel are **actually consumed**
and produced by each transformation. By statically analyzing these transformations we have been able to discover what they do, and infer chaining constraints from this knowledge.

The reminder of the paper is organized as follows. Section 2 presents a scenario involving a number of endogenous transformations operating on a single metamodel. Our transformation analysis approach is described in Section 3, and its application is presented in Section 4. The results are discussed in Section 5. Finally, Section 6 concludes.

## 2 Motivating Example 2.1 Interoperability Of Constraint Programming Languages

In Constraint Programming (CP), one of the main goals is to define problems based on variables, domains and constraints such that a CP solver can compute their solutions [16]. In CP, various kinds of languages are used to state problems.

For instance, the language of the ECLiPSe**solver [2] is based on logic and Prolog,**
whereas OPL [8] (Optimization Programming Language) is a solver-independent language based on high-level modeling constructs. Some solvers have only programming APIs like ILOG Solver [14] or Gecode [17]. More recently, the definition of high-level modeling languages is becoming a hot topic in CP [15]. Then, new modeling languages have been developed such as Zinc and MiniZinc [13],
Essence [7] and s-COMMA **[18]. In these three cases, the high-level modeling**
language is translated into existing CP solver languages by **using a flat intermediary language to ease the translation process and to increase the reusability of**
most transformations and reformulation tasks. This process is mainly achieved by hand-written translators using parsers and lexers.

In a recent work [4], model engineering was used to carry out this process from s-COMMA models to some solver languages. Then, this approach has been