

![0_image_0.png](0_image_0.png)

## 2.2 Problem

In this paper, we want to tackle the issues relating to the efficient management of a set of endogenous transformations. Since the source and target metamodels are similar, no additional information can be extracted **from the header of**
an ATL transformation. Considering only this knowledge, we **may think that** endogenous transformations can be chained without any problem, but this is not true. The solution proposed by [21] is therefore not sufficient to address this problem because it only considers the signature (or header) of transformations. As shown in the motivating example, endogenous transformations achieve model reformulation or optimization steps. They have to be efficiently and correctly chained to avoid useless steps - some steps may create **elements that are**
removed by another step - and to reach the requirements of the **target solver** language. Our goal is to discover the role of endogenous model transformations in a parameterizable chain.

Endogenous transformations can be typed using their source **and target element types, i.e. a sub-set of the metamodel of these models. Thus, considering**
the set of source elements of an endogenous transformation, **we can assess the set** of source models supported by it without any loss. The set of target elements also allows us to type generated models. Then, we may be able to verify endogenous transformation chains. Moreover, using a search/optimization algorithm we may be able to find the "best" chain and thus automating the chaining of endogenous transformations according to an input metamodel and to an output metamodel corresponding to a high-level exogenous transformation.

## 3 Transformation Analysis 3.1 Identifying Domains And Codomains

In order to correctly chain model transformations it is necessary to have a certain understanding of what they do. Although it is not enough, source and target