metamodels information is essential. The model MB produced by a given transformation t1 conforms to its target metamodel MMB**. It may only be fed as**
input to another transformation t2 with the same metamodel MMB **as source**
metamodel.

This constraint may be expressed in functional terms as shown in [21]:
transformations are considered as functions, and metamodels type their parameters in the case of simple transformations (Higher). For instance, if the source metamodel of t1 is MMA, and the target metamodel of t2 is MMC **then:**
t1 : MMA → MMB and t2 : MMB → MMC**. In this notation the name of a**
metamodel is used to identify the set of models that conform to it. Thus, transformation t1 **is considered as a function of domain the set of models conforming**
to MMA, and of codomain the set of models conforming to MMB. In this example, if t2 is total then it may be applied to the output of t1 **because the codomain**
of t1 **is also the domain of** t2.

In practice, model transformations are often partial functions: they do not map every element of their declared domain to an element of their codomain.

For instance, t2 may only work for a subset MM′B ⊂ MMB. If t1 **is surjective**
(i.e., it can produce values over its whole codomain) then t2 **cannot be applied to**
all output models that t1 **can produce. This shows that problems can arise when**
the domain of transformations (i.e., their source metamodels) is underspecified (i.e., too broad). If codomains (or target metamodels) are also underspecified, then there may not be any actual problem. For instance, if t1 **only produces**
results over MM′′B ⊆ MM′B then t2 may be chained to t1**. Therefore, precisely**
identifying the actual domain and codomain of a transformation (i.e., definition domain and its image) would be an improvement over the current practice.

However, doing so is often complex because it requires deep analysis of transformations (e.g., not only source elements of transformation rules but also every navigation over source elements). Moreover, the semantics **of a specific metamodel or transformation may make the problem harder. For instance, some**
endogenous transformations have a fixed point semantics and **are called until** a given type of element has been eliminated. Each intermediate step produces elements of this type except the last one. An example of such a **transformation** would eliminate for loops from a constraint program one nesting level at a time.

The objective of this paper is to provide a solution applicable with the current state of the art: actual domains and codomains cannot currently be 1) precisely computed, and 2) automatically checked. Therefore, if an approximation (because of 1)) is computed it must be represented in a simple form that the user may understand quickly (because of 2): the user has to interpret it). An example of such a simplification is the list of concepts (i.e., model element types coming from the metamodels) that are taken as input or produced as output of a transformation. This is the first analysis that has been applied to the motivating example presented in Section 2 with relatively poor results if considered alone.