
## 3.2 Abstracting Rules

Other kinds of information may be used to better understand what a transformation does. ATL transformations are composed of rules that match source elements according to their type and some conditions (these **form the source pattern of the rule), and that produce target elements of specific types (these form**
the target pattern of the rule). A transformation analyzer may produce an abstract representation of a set of transformation rules. This simplified description may take several forms.

One may think of representing the mapping between source and target metamodel concepts defined by the rules. Model weaving may be used **for this purpose**
as shown in [6,11]. However, such a representation would be relatively verbose:
there are as many mappings as rules, and the number of rules is **typically close** to the number of source or target concepts.

An additional simplification may be devised in the case of endogenous transformations in which elements are either copied (same target **and source type)**
or mutated (different target and source types). These actions may be applied on every element of a given type, or only under certain conditions. Moreover, ATL lazy rules that are only applied if explicitly referenced (i.e., this is a kind of lazy evaluation) may also be used. Table 1 summarizes this **classification of**
endogenous transformation rules. The first dimension (in columns) is the kind of action (copy or mutation) that is performed by the rule. The second dimension
(in rows) corresponds to the cases in which the action is taken: always, under specific conditions, or lazily. Corresponding examples of rules taken from the motivating example are given below. No example of always or lazy mutation is given because there is no such case in the transformations **of the motivating** example.

![0_image_0.png](0_image_0.png)

Listing 1.1 gives a rule that always copies data types. The target type (line 5) of such a rule is the same as its source type (line 3). It is concept **DataType** of the CPPivot **metamodel in this listing. Moreover, it also copies all properties**
(e.g., source element name is copied to target element name at line 6). However, property-level information is not always so simple to identify. In many cases some properties are copied while others are recomputed. In order to keep the information presented to the user simple, property-level information is ignored in the current implementation of the transformation analyzer.