
## Iii. Problem Outline

![0_Image_0.Png](0_Image_0.Png)

This research focuses on the development of an MDS for the disease known as ABM, integrating the CBR and RBR methods, making special emphasis on the implementation of the adaptation of the CBR cycle stage. This stage is fundamental in a case-based MDS, given that once recovered the most similar case, it is highly probable to find differences in the descriptions of the problems. This could then indicate differences in the solutions, which entails a possible error in the diagnosis. 

On the other hand, the adaptation capabilities of a CBR 
system applied to a CDSS allow its usage by not so experienced physicians. This fosters its utility as a support tool also in the medical learning and practice. 

## Iv. Theoretical Framework A. Clinical Decision Support Systems

A Clinical Decision Support System (CDSS) is an expert system that provides support to certain reasoning tasks, in the context of a clinical decision. [1] 
A medical diagnostic decision support system - MDS - is defined as a computer algorithm aimed at assisting the doctor in one or more stages that comprise the medical diagnostic process. [1] 
One of the first CDSS that appeared in the marketplace is MYCIN, a system developed at Stanford University. This system was designed to diagnose and recommend treatments for blood infections. [8], [9] 
Other systems of interest are: IMAGECREEK - image analysis - [10], CADI - medicine students' tutorial - [11], 
SCINA - diagnosis of cardiac diseases - [12], CAREPARTNER - diagnosis and treatment scheduling of stem cells transplant - [13], AUGUSTE - diagnosis and scheduling of Alzheimer treatment - [14], T-IDDM - treatment scheduling of diabetes - [15]. 

There are many computer techniques and methods –
especially in the Artificial Intelligence field - that have been applied in the last 30 years or more in the development of systems of this nature: pattern analysis, neural networks, expert systems and Bayesian networks, among others. 

(IJCSIS) International Journal of Computer Science and Information Security, Vol. 7, No. 2, 2010 irritability, facial paralysis, cervical adenopathies, haemocultivation with bacteria, bacteria in CSF, muscular hypotonicity, cloudy aspect CSF, clear aspect CSF, hydrocephaly in ecography, tumors in tomography, among many others. [6], [7] 
The combination of the presence of several of these symptoms allows identifying the disease under study, but it could also be indicative, to a greater or lesser extent, of other diseases identified as "differential diagnoses". The relevant differential diagnoses in the case of ABM are: Acute Viral Meningitis, Tuberculous Meningitis, Encephalitis, Brain Abscess, Meningism, Meningeal reaction to nearby inflammation, Meningeal Haemorrhage and Brain Tumor. [7]. The task of the doctor is to diagnose accurately the disease within these alternatives. 

The rule based reasoning is one of the most used techniques 
[16], [17], and in recent years case-based reasoning has gained much importance in this field [18], [19], [20], [4]. 

## B. Case-Based Reasoning (Cbr)

Case Based Reasoning is a methodology for problem solving that focuses on the reutilization of past experience. It is based on solutions, information and knowledge available in similar problems previously solved. The implementation of this method requires the existence of a knowledge base that contains the cases that contain previous experience. It is also necessary to count with a mechanism that allows us to infer, for a new case, the solution based on foregoing cases. CBR's basic principle is that *similar problems* will have *similar solutions.*
[19], [20], [21], [4], [18] 
In CBR the structures handled are known as *cases.* A case represents a problem situation. It could be more formally defined as contextualized knowledge that represents past experience, and implies an important teaching to accomplish the objectives of a rational agent. [19], [20], [18], [22] 
In Figure 1 is presented the CBR cycle. It can be observed the presence of 4 sub-processes or stages ("Retrieve", "Reuse", 
"Revise" and "Retain") that explicate the operation of this methodology. 

First, when a new problem is posed to the system, it proceeds to identify correctly the current case, and *retrieve* the most *similar* cases from the knowledge base. 

Once the cases have been obtained, the information and knowledge contained in them is reused to solve the new problem, from which a solution to propose to the user is reached. This stage might possibly entail an *adaptation* process of the solution of the retrieved case, considering the differences between both problematic situations. 

Also, these systems include a stage of proposed solution assessment, and a later *learning* from this case. Then, after the reusage stage it proceeds to the proposed solution *revision* process, which is assessed and *repaired* if it fails, obtaining a confirmed or revised solution. 