(IJCSIS) International Journal of Computer Science and Information Security, Vol. 7, No. 2, 2010 symptoms that were not considered for this process are not relevant enough to have an impact in the diagnosis. 

Once the most similar adaptation case has been selected, the associated similarity degree is assessed, once again, based on a set threshold. If this threshold is exceeded, the reutilization of the adaptation case is made directly - a null adaptation is done - the adapted solution coincides with the solution of the retrieved case. This is due to the fact that the application context of the retrieved experience and the current context are virtually identical. If the retrieved adaptation case is not similar enough, the system proceeds to adapt based in rules contained in the knowledge base. As well as in the case of the prediagnosis stage rules, the domain problem was investigated with the collaboration of an expert doctor. Two main categories of situations have been determined: 
 a) Situations in which the differential presence of a symptom allows excluding a certain differential diagnosis. For instance, IF *Koch's Bacillus* THEN *Discard ABM*
This rule indicates that if the current case (P2) shows 
"Koch's Bacillus", but the retrieved case (P1) did not, the differential diagnosis of Acute Bacterial Meningitis is discarded. If such diagnosis was given in the solution of the previous case (S1) then it can be removed, and it will not be contained in the solution of the current case. (**S2).**
 b) Situations in which, under the intuition of a given diagnosis and given a difference in the present symptoms another diagnosis is sensed; or its certainty level is modified. For example, IF ABM *primary* AND *Crystalline aspect* THEN 
ABM *Differential* This rule indicates that if the solution to the previous case (S1) presents ABM as a primary diagnosis, but the cases differ in that the current (P2) presents 
"Crystalline aspect in the cerebrospinal fluid" and the previous case (P1) does not, then in the current solution (S2) such disease has to be considered as a differential diagnosis, not primary. 

The different rules modify the facts in the working memory of the inference engine in such way that at the end of the processing the set of resulting diagnoses is retained in it. 

The successive application of rules has a correspondence to each of the transformations or adaptations carried out on the original solution, when there is a difference between symptoms. 

Once the solution has been obtained (either by the reutilization of the diagnostic case or by its adaptation), it is presented to the user and the system requires her judgment or assessment - success or failure - as for the correction of the suggested diagnosis. If the case fails, the system offers the user the possibility of repairing it, setting the appropriate diagnosis 
(primary and differentials) - the case is then assumed as successful-. 

The next step is the *retention* stage, in which the user is asked if she or he wishes to retain the new case. Moreover, if an adaptation process has been performed, then the user is given the option of storing the adaptation knowledge, which will be available after the new experience. A new adaptation case can be learned either from the reutilization of a previous adaptation case or from the successive application of rules. 

This type of adaptation process allows, at the beginning, the adaptation to be mostly based in the set of surveyed rules. 

However, when the system gains experience the reusability of adaptation cases increases, and the system turns less dependent on the rule set. 

If the system makes any mistakes when adapting, the user has the possibility of indicating such situation and specifying the correct solution. In this way, the system is able to learn a new adaptation case from the user himself. If this user is a physician with vast experience in this field, this feature is key to the learning of new experiences. 

VI. GENERATION OF THE DIAGNOSIS CASE BASE
One of the main points in the construction of the system consists in obtaining a set of diagnoses large enough - to test the performance of the system - relevant, and representative of real world population. 

In previous works of the research group (development of a diagnostic expert system of Acute Bacterial Meningitis based on a Bayesian inference engine [7]), a database of occurrence probabilities of the disease under study (ABM) and its differential diagnoses, based on 10000 medical visits, was available. Likewise, for each disease the corresponding probability of presenting the symptoms under study is available. 

Based on these diseases and symptoms probabilities and using the Montecarlo method (assuming normal and uniform distributions in each case) several simulations were performed to obtain a set of virtual "cases".

This initial set was subject to several steps of revision: in first place, the cases with clearly abnormal or extremely improbable situations were removed; and then each of the cases was validated by medical experts. The result is an initial 
"cured" database that is representative of the real population –
it is based on probabilities extracted from the population, and the combinations obtained have been validated by field experts. 

Besides the validation process, the expert provided the real diagnosis for each of the cases in the base, for which it can be considered as a set of real cases. 

VII. ASSESSMENT OF THE SYSTEM'S PERFORMANCE
The system's performance has been assessed considering three indicators: accuracy, robustness before partial information, and learning capacity. 

## A. Accuracy

In the context of this research, *accuracy* has been defined as the *amount of successful hits* the system reached. For this experiment, a 30-case sample extraction was made (size of the sample calculated according to the population size, based on 