(IJCSIS) International Journal of Computer Science and Information Security, Vol. 7, No. 2, February 2010 2. *Multithreading:* The agent is based on multithreading and opens thread for each registry listed with itself. Multiple agents have been used in our proposed framework and each agent will search desired service from its listed registries and returned the results to matching engine.

## V. Proposed Technique

A. *Working.* The detailed flow of proposed discovery mechanism is explained as follows: 
1. Service providers register their web services in registries on global web through registration module. 

2. Service requester requests for web service through discovery module. 

3. Translator is used for translation of user input to a form that can be efficiently used by the system. From translator request goes to matching engine. 

4. Matching engine tries to discover the desired service from local cache and passes request to indexer. Indexer searches the desired service from local cache based on indexing and categorization. If the results are valid then indexer returns desired results to matching engine. 

5. Otherwise matching engine tries to discover the desired service from registries available on the web, using multithreaded agent approach. Agents search the services from its listed registries and send the discovered services to matching engine. 

6. A timestamp is maintained with each service reference which has a specific value. And web services are updated in local cache from web when timestamp expires. 

7. Matching engine stores the service references in local cache for future reference. Also it sends result to translator which translates result into user understandable form and results are returned to requester. 

B. *Pseudo Code:* The pseudo code of proposed technique is given as: 
Algorithm: Dynamic Web Services Discovery Input: Request for Web service Output: Desired Service Services registered in UDDI registries; User enters input request for web service; for each input Translator translates input; Input goes to Matching Engine; Matching Engine passes request to Indexer; Indexer search from local cache based on classification and indexing; Indexer search from local cache based on classification and indexing; 

## If Service Found In Local Cache

 Return result to user; If no service found or timestamp expires Matching Engine passes request to Agents; Agents discover service from its listed UDDI registries; Keyword and fuzzy logic based matching from registries; CSP solver filters matched services based on specified constraints; Matching Engine add references of matched services in local cache through indexing; Service references added in local cache for future reference; Return results to user through translator; 

![0_image_1.png](0_image_1.png)

 Return no service found; 

## Vi. Implementation & Evaluation 

![0_Image_0.Png](0_Image_0.Png)

![0_Image_2.Png](0_Image_2.Png)

![0_Image_3.Png](0_Image_3.Png)

The implementation has been done using Netbeans 6.5 and open source UDDI which is Apache jUDDIv3 (java implementation of Universal Description Discovery and Integration version 3). Ruddi is used to access UDDI registry which is java API for developing, deploying reliable, scalable and secure application that query and publish to UDDI 
registries. UDDI4J and JAXR (Java API for XML Registries) is also java API for accessing registries but the drawbacks are that UDDI4J only supports jUDDI version 2 and JAXR is for all XML based registries for example UDDI, ebXML etc. Xerces APIs are also used for parsing XML request and responses. We have used apache jUDDI version3 and multiple jUDDI's on multiple servers by implementing multithreaded approach. 

For testing we have published multiple businesses and services on registry. We have used WordNet for synonyms and RitaWordnet is a java API to access WordNet. WordNet is used for matching businesses and services from registry. Users can search businesses and services by synonyms which are already saved in WordNet. The implementation mainly comprises of UDDI registries, matching engine, service providers, service requesters and dynamic services discovery mechanism. Fig 5 shows the GUI of our dynamic web services discovery application. User sends discovery request using our application which then goes to the translator. Translator send request to matching engine which tries to discover the desired service from local cache based on indexing. As this service is not present in local cache, it sends request back to Matching Engine. Matching Engine sends request to agent. Agent sends multiple threads to own multiple listed registries and starts searching services. It discovers the matched services and returns the valid services to Matching Engine. Matching 