the context of the Semantic Web [4]. For example, the current standard language for specifying ontologies, the Web Ontology Language OWL is based on Description Logics.

It is very natural to extend DLs to the fuzzy case in order to manage fuzzy/vague/imprecise pieces of knowledge for which a clear and precise definition is not possible. For a good and recent survey on the advances in the **field of** fuzzy DLs, we refer the reader to [14]. One of the challenges of the **research in** this community is the fact that different families of fuzzy operators **(or fuzzy** logics) lead to fuzzy DLs with different properties.

In fuzzy logic, there are a lot of families of fuzzy operators (or fuzzy logics). Table 1 shows the connectives involved in what are considered the main four families. The most famous families correspond to the three basic continuous t-norms (i.e., Lukasiewicz, G¨odel and Product [10]) together with an R-implication1. Besides these three, we also point out Zadeh's family corresponding to the operators originally proposed by Lotfi A. Zadeh in his **seminal**
work [23]: G¨odel t-norm and t-conorm, Lukasiewicz negation and **Kleene-Dienes** implication.

| family      | t-norm α ⊗ β      | t-conorm α ⊕ β   | negation ⊖α   | implication α ⇒ β   |    |       |
|-------------|-------------------|------------------|---------------|---------------------|----|-------|
| Zadeh       | min{α, β}         | max{α, β}        | 1 − α         | max{1 − α, β}       |    |       |
| Lukasiewicz | max{α + β − 1, 0} | min{α + β, 1}    | 1 − α         | min{1 − α + β, 1}   |    |       |
| Product     | α · β             | α + β − α · β    |  1,               | α = 0               |  1,    | α ≤ β |
| 0,          | α > 0             | β/α,             | α > β         |                     |    |       |
| G¨odel      | min{α, β}         | max{α, β}        |  1,               | α = 0               |  1    | α ≤ β |
| 0,          | α > 0             | β,               | α > β         |                     |    |       |

The DL ALC [17] (Attributive Language with Complements) is a very popular logic, usually considered as a standard. ALC **is a notational variant of the**
multimodal logic Kn **(which essentially corresponds to not having a knowledge** base) [16], and it is well known that Kn **verifies the Finite Model Property** (FMP) (see [5, Proposition 2.15]). A logic verifies the FMP iff every satisfiable theory of the logic is also satisfiable by a finite model.

However, the situation is different in the fuzzy setting. It is also well **known**
(see [11, Theorem 2] and [12, Theorem 8]2) that in the context of fuzzy ALC the satisfiability problem for ABoxes (that is, the TBox is empty) in a finite **model** coincides with the satisfiability in the bigger class of witnessed models. **This** fact is used in [11] to prove that fuzzy ALC **under Lukasiewicz enjoys the FMP**
since it is also known that first-order formulae satisfiable under Lukasiewicz semantics are always satisfiable in a witnessed model (see [13]). On the other hand, the FMP fails under G¨odel and Product semantics even for ABoxes [11, Example 2].

1Every left-continuous t-norm ⊗ has associated a unique operation ⇒ **called the residuum**
of ⊗ (often called an R-implication) and defined as α ⇒ β **= sup** {γ | α ⊗ γ ≤ β}.

2**The result is formulated in a different framework (for example, without explicitly having**
a t-conorm), but the same proof given there works.