- **A sampling-based approach.**
The generic implementation of RefereeToolbox makes possible to combine these three classes and their instances without restriction.

## 2 What Is A Referee Function?

For an introduction to the theory of referee function, please refer to [3].

## 2.1 Basic Belief Assignment

Let GΘ **be a** *complete distributive lattice*. A *basic belief assignment* **[1, 2] is a mapping** m from elements of GΘ onto [0, **1] such that:**

$$\sum_{X\in G^{\Theta}}m(X)=1\quad{\mathrm{and}}\quad m(\varnothing)=0\ .$$
$$\left(1\right)$$

## 2.2 Referee Function

Definition. A referee function over GΘ for s **sources of information and with context** γ is a mapping *X, Y*1:s 7→ F(X|Y1:s; γ) defined on propositions *X, Y*1:s ∈ GΘ **, which satisfies for**
any *X, Y*1:s ∈ GΘ :

$$F(X|Y_{1:s};\gamma)\geq0\;\;\;\mathrm{and}\;\;\;\sum_{X\in G^{\Theta}}F(X|Y_{1:s};\gamma)=1\;,$$

A referee function for s sources of information is also called a s**-ary referee function. The**
quantity F(X|Y1:s; γ**) is called a** *conditional arbitrament* between Y1:s in favor of X**. Notice** that X is not necessary one of the propositions Y1:s **; typically, it could be a combination of**
them. The case X = ∅ **is called the** *rejection case*.

Fusion rule. Let be given s basic belief assignments (bba) m1:s and a s**-ary referee function**
F with context m1:s . Then, the fused bba m1 **⊕· · ·⊕**ms[F]
∆= ⊕[m1:s|F**] based on the referee**
F **is constructed as follows:**

$$\oplus[m_{1:s}|F](X)=\frac{I[X\neq\emptyset]}{1-z}\sum_{Y_{1:s}\in C^{\Theta}}F(X|Y_{1:s};m_{1:s})\prod_{i=1}^{s}m_{i}(Y_{i})\;,$$  where $z=\sum_{Y_{1:s}\in C^{\Theta}}F(\emptyset|Y_{1:s};m_{1:s})\prod_{i=1}^{s}m_{i}(Y_{i})\;,$  $$I[X\neq\emptyset]=1\mbox{if}X\neq\emptyset,\mbox{and}I[X\neq\emptyset]=0\mbox{if}X=\emptyset.$$

The value z **is called the** *rejection rate*.

## 2.3 Examples Of Referee Functions

Dempster-shafer rule. Let be given s **sources of information characterized by their bbas**
m1:s. The fused bba mDST obtained from m1:s **by means of** *Dempster-Shafer* **fusion rule [1, 2]**