
## 3.1.6 Pest-Trap

Pest-trap identifies crops that can be used to trap or combat one or more plant problems. For example, in recent years, *Striga sp***, has been noted to be one of the main hindrances to maize** 
productions in the tropics. LEXSYS may be used to find out a legume that can combat this menace. 

 

## 3.2 Selection Module

The method adopted is to save criteria list in a predefined array. This is saved as arguments type definition and its correspondent value for in arrays. These arrays are evaluated from the database of legume. The typical programming example is shown below. 

{Evaluate} (VAL(&q[1])<u[1].AND. &q[1]\#' ').AND. (VAL(&r[1])>v[1] .OR.; &r[1]=' ') .AND. (VAL(&q[2])<u[2].AND. &q[2]\#' ').AND. (VAL(&r[2])>v[2] .OR.; &r[2]=' ') .AND. (VAL(&q[3])<u[3].AND. &q[3]\#' ').AND. (VAL(&r[3])>v[3] .OR.; 
 &r[3]=' ') 
………. {/Evaluate} 
 where q(n) and r(n) are the argument types while u(n) and v(n) are the argument values 

## 3.3 Why Module

The why module is also central in LEXSYS because it gives feedback room to check why a preconceived legume species is not included in a desired selection. This module makes use of the selection list, criteria list and the database (which contain the selection property type and value). Typical programming example is Procedure Why(Parameter(Legume Species in mind)) {Evaluate} 
goto <legume species> If ((VAL(&q[k])<u[k] .AND. &q\#' ') .AND. (VAL(&r[k])>v[k] .OR. &r[k]=' ')) then (q[k])=[critType],'Not adapted to &[critType]
end if 
{/Evaluate} 
where q[k] is the lower bound kth selection criteria type and u(k) is the lower bound kth **selection** 
value. r[k] is the kth upper bound property type in the legume database and v[k] is the kth **upper** 
bound property value in the database 

## 4.0 The Intelligent Agents

One definition of intelligent agents is that they are systems aim at helping the user in finding information. This is not the only application of intelligent agent but LEXSYS can be developed bearing this piece of information in mind. One of the widely method adapted in intelligent agents is the machine learning. Two approaches are used in incorporating machine learning into intelligent agents. These are content-based and collaborative approaches [Mladenic 99]. 

 In the content-based approach, user's request is matched with the content of WEB sites using one of the more than eight different algorithms [Lewis et al **]. Whatever model or algorithm that is** used is not our immediate concern in this paper. In the collaborative approach, user's profile or information being researched is complemented with inputs from other users who have similar 