# Rational Value Of Information Estimation For Measurement Selection

David Tolpin Computer Science Dept., Ben-Gurion University, 84105 Beer-Sheva, Israel Solomon Eyal Shimony Computer Science Dept., Ben-Gurion University, 84105 Beer-Sheva, Israel ABSTRACT. Computing value of information (VOI) is a crucial task in various aspects of decision-making under uncertainty, such as in meta-reasoning for search; in selecting measurements to make, prior to choosing a course of action; and in managing the exploration vs. exploitation tradeoff. Since such applications typically require numerous VOI computations during a single run, it is essential that VOI be computed efficiently. We examine the issue of anytime estimation of VOI, as frequently it suffices to get a crude estimate of the VOI, thus saving considerable computational resources. As a case study, we examine VOI estimation in the measurement selection problem. Empirical evaluation of the proposed scheme in this domain shows that computational resources can indeed be significantly reduced, at little cost in expected rewards achieved in the overall decision problem.

## 1 Introduction

Problems of decision-making under uncertainty frequently contain cases where information can be obtained using some costly actions, called measurement actions. In order to act rationally in the decision-theoretic sense, measurement plans are typically optimized based on some form of value of information (VOI). Computing VOI can also be computationally intensive. Since frequently an exact VOI is not needed in order to proceed (e.g. it is sufficient to determine that the VOI of a certain measurement is much lower than that of another measurement, at a certain point in time),
significant computational resources can be saved by controlling the resources used for estimating the VOI. This paper examines this tradeoff via a case study of measurement selection. In general, computation of value of information (VOI), even under the commonly used simplifying myopic assumption, involves multidimensional integration of a general function [Russell and Wefald, 1991]. For some problems, the integral can be computed efficiently
[Russell and Wefald, 1989]; but when the utility function is computationally intensive or when a non-myopic estimate is used, the time required to compute the value of information can be significant [Heckerman et al., 1993] [Bilgic and Getoor, 2007] and must be taken into account while computing the net value of information. This paper presents and analyzes an extension of the known greedy algorithm that decides when to recompute VOI of each of the measurements based on the principles of limited rationality [Russell and Wefald, 1991]. Although it may be possible to use this idea in more general settings, this paper mainly examines on-line most informative measurement selection [Krause and Guestrin, 2007]
[Bilgic and Getoor, 2007], an approach which is commonly used to solve problems of optimization under uncertainty [Zheng et al., 2005] [Krause et al., 2008]. Since this approach assumes that the computation time required to select the most informative measurement is negligible compared to the measurement time[Russell and Wefald, 1991], it is important in this setting to ascertain that VOI estimation indeed does not consume excessive computational resources.

1