
## 4.1 The Ackley Function

The Ackley function [Ackley, 1987] is a popular optimization benchmark. The two-argument form of the Ackley function is used in the experiment; the function is defined by the expression (7):

$$A(x,y)=20\cdot\exp\left(-0.2\sqrt{\frac{x^{2}+y^{2}}{2}}\right)+\exp\left(\frac{\cos(2\pi x)+\cos(2\pi y)}{2}\right)\tag{7}$$

In the optimization problem, the utility function is u(z) = tanh(2z), the measurements are normally distributed around the true values with variance σ 2m = 0.5, and the measurement cost is 0.01. There are uniform dependencies with σ 2w = 0.5 in both directions of the coordinate grid with a step of 0.2 along each axis. The results for the blinkered scheme[Tolpin and Shimony, 2010] are presented in

![0_image_0.png](0_image_0.png)

## 4.2 Svm Parameter Search

An SVM (Support Vector Machine) classifier based on the radial basis function has two parameters: C and γ. A combination of C and γ with high expected classification accuracy should be chosen, and an efficient algorithm for determining the optimal values is not known. A trial for a combination of parameters determines estimated accuracy of the classifier through cross-validation.

The svmguide2 [wei Hsu et al., 2003] dataset is used for the case study. The utility function is u(z) = tanh(4(z − 0.5)), the log C and log γ axes are scaled for uniformity to ranges [1..21] and there are uniform dependencies along both axes with σ 2w = 0.4. The measurements are normally distributed with variance σ 2m = 0.25 around the true values, and the measurement cost is cm = 0.01.

The results for the myopic scheme are presented in Figure 2.

## 4.3 Discussion Of Results

In all experiments, a significant decrease in the computation time is achieved with only slight degradation of the reward; performance of the rationally recomputing algorithm decreases slowly with the computation cost and exceeds performance of the algorithm that makes random measurements even when VOI for only a small fraction of measurements is recomputed at each step.