
## 4.2 The Hamming Measure Of Similarity

The first most obvious method of comparing two matrices or their signatures would be to compute the number of entries they have in common and the number of entries they differ by. Let X = [xi j] and Y = [yi j] be signatures of matrices, i.e.

i ∈ {1*,...*2 d n 2 e+1}, j ∈ {1*,...*2 d n 2 e}. Let

$c(x_{ij},y_{ij})=\left\{\begin{array}{ll}1&\mbox{if$x_{ij}\neq 0$and$y_{ij}\neq 0$,}\\ 0&\mbox{otherwise,}\end{array}\right.$  $u(x_{ij},y_{ij})=1-c(x_{ij},y_{ij})$.  
Now let us count the number of *common points* and *uncommon points*

(64)  $\left(65\right)$  . 
$C(X,Y)=\sum_{i,j}c(x_{ij},y_{ij})$,  $U(X,Y)=\sum_{i,j}u(x_{ij},y_{ij})$.  
(66)  $\binom{67}{6}$  . 
$$\operatorname{if}U(X,Y)\neq0,$$ $$\operatorname{otherwise}.$$
Finally, the Hamming measure for comparing the signatures of matrices computes the ratio of common and uncommon points

$$H(X,Y)={\left\{\begin{array}{l l}{{\frac{C(X,Y)}{U(X,Y)}}}\\ {\infty}\end{array}\right.}$$
U(X,Y)if U(X,Y) 6= 0,
∞ otherwise.
$$(68)$$

Such a measure of similarity is fairly fast to calculate since it does not involve computing any mathematical operations except addition and the final division of C(X,Y)
and U(X,Y).

## 4.3 The Euclidean Measure Of Similarity

The second most obvious method for computing matrix similarity is via Euclidean distance. Again, let X = [xi j] and Y = [yi j] be signatures of matrices for i ∈
{1*,...*2 d n 2 e+1}, j ∈ {1*,...*2 d n 2 e}. Let

$$E(X,Y)=\left\{\begin{array}{ll}\frac{1}{\sum\limits_{i,j}\sqrt{|x_{ij}|^{2}-|y_{ij}|^{2}}}&\mbox{if}\sum\limits_{i,j}\sqrt{|x_{ij}|^{2}-|y_{ij}|^{2}}|\neq0,\\ \infty&\mbox{otherwise.}\end{array}\right.\tag{69}$$

This kind of measure uses more mathematical operations requiring greater time to compute - the modulus of a complex number, multiplication and the square root.

The Hamming measure involved calculating only addition and the ratio of common and uncommon points. Calculating the ratio in both measures results in those measures taking on a role of "probability" that the matrices are alike rather than describ-