
## 6 Comparison With Previously Developed Models

The most important performance measure of any new distributed representation model is the comparison of its efficiency in relation to previously developed models.

This Section comments on test results performed on GA, BSC and HRR.

Naturally, the question of data size arises as a GA clean-up memory item may store information in more than one vector (blade), unlike in architectures known so far. Further, the preferred way of recognition for GA requires the usage of matrix signatures comprising up to 21+2d N
2 eentries. However, since one only needs blades to calculate the matrix signatures, it has been assumed that tests comparing efficiency of various models should be conducted using the following sizes of data
- N bits for a single blade in GA,
- KN bits for a single vector in BSC and HRR,
where K is the maximum number of blades stored in a complex sentence belonging to GA's clean-up memory under agent-object construction with odding blades. For the data set presented in Table 1 the maximum number of blades is stored in items (3d) and (5b) and is equal to 13. Such an approach to the test data size will certainly prove redundant for GA sentences having a lesser number of blades, nevertheless, it is only fair to provide relatively the same data size for all compared models.

Figures 17 through 19 show comparison of performance for GA, BSC and HRR,
tested sentences range in meaningful-to-noisy blades ratio from 1:2 to 7:2. Clearly, GA with the use of Hamming and Euclidean measure ensures quite a remarkable recognition percentage for sentences of great complexity and therefore - great noise, whereas the HRR model works better for statements of low complexity. There is no significant difference in performance of the BSC model as far as complexity of tested sentences is concerned. BSC does remain the best model, provided that vector lengths for BSC are sufficiently longer than that of GA. Under uniform length of vectors and blades GA recognizes sentences better than HRR or BSC, regardless of their complexity.

## 7 Conclusion

We have presented a new model of distributed representation that is based on the way humans think, while models developed so far were designed to use arrays of numbers mainly in order to be easily simulated by computers.

After a brief recollection of the main ideas behind the GA model, we investigated three types of sentence constructions, namely the Plate construction, the agent-object construction and the agent-object construction with odding blades. Two methods of asking questions were also investigated. As a result, in face of shortcomings of recognition based solely on the inner product, matrix representation has been employed as a recognition tool for the GA model. Using test results computed on