
## 6. What Is Neural Network?

An Artificial Neural Network (ANN) is an information processing paradigm that is inspired by the way biological nervous systems, such as the brain, process information. The key element of this paradigm is the novel structure of the information processing system. It is composed of a large number of highly interconnected processing elements (neurons) working in unison to solve specific problems. ANNs, like people, learn by example. 

## 6.1 Why Use Neural Networks?

Neural networks, with their remarkable ability to derive meaning from complicated or imprecise data, can be used to extract patterns and detect trends that are too complex to be noticed by either 

humans or other computer techniques.

![0_image_0.png](0_image_0.png)

Other advantages include: 

1. Adaptive learning: An ability to learn how to do tasks based on the data given for training or initial experience. 

2. Self-Organization: An ANN can create its own organization or representation of the information it receives during learning time. 

Real Time Operation: ANN computations may be 
carried out in parallel, and special hardware devices are being designed and

3. manufactured which take advantage of this capability. 

4. Fault Tolerance via Redundant Information Coding: Partial destruction of a network leads to the corresponding degradation of
performance. However, some network capabilities may be retained even with major network damage. 

## 6.2 How The Human Brain Learns?

In the human brain, a typical neuron collects signals from others through a host of fine structures called *dendrites*. The neuron sends out spikes of electrical activity through a long, thin stand known as an *axon*, which splits into thousands of branches. At the end of each branch, a structure called a *synapse* converts the activity from the axon into electrical effects that inhibit or excite activity from the axon into electrical effects that inhibit or excite activity in the connected neurons. When a neuron receives excitatory input that is sufficiently large compared with its inhibitory input, it sends a spike of electrical activity down its axon. 

![0_image_1.png](0_image_1.png)

Learning occurs by changing the effectiveness of the synapses so that the influence of one neuron on another changes.

## 6.3 From Human Neurons To Artificial Neurons

![0_Image_2.Png](0_Image_2.Png)
