Nystr¨om method. The runtime of this algorithm is O(l 3 + nl2): O(l 3) for SVD on W and O(nl2) for multiplication with C. The Nystr¨om method is often presented with an additional step whereby W **in (4) is**
replaced by its rank-k approximation, Wk**, for some**
k < l, thus generating Gek, the rank-k Nystr¨om approximation to G**. In this case, the runtime of the**
algorithm is reduced to O(l 3 + nlk).

## 2.2 Coherence

Although the Nystr¨om method tends to work well in practice, the performance of this algorithm depends on the structure of the underlying matrix. We will show that the performance is related to the size of the entries of the singular vectors of G, or the coherence of its singular vectors. We define Vr **as the top**
r singular vectors of G**, and denote the coherence of**
these singular vectors as µ(Vr**), which is adapted from**
Cand`es and Romberg (2007).

Definition 1 (Coherence). The coherence **of a matrix**
of Vr **with orthonormal columns is defined as:**

$$\mu(V_{r})=\sqrt{n}\operatorname*{max}_{i,j}|V_{r(i)}^{(j)}|\ .$$

The coherence of Vr **is lower bounded by 1, as is the**
case for the rank-1 matrix with all entries equal to 1/
√n, and upper bounded by √n**, as is the case for**
the matrix of canonical basis vectors. As discussed in Cand`es and Recht (2009); Cand`es and Tao (2009),
highly coherent matrices are difficult to randomly recover via matrix completion algorithms, and this same logic extends to the Nystr¨om method. In contrast, incoherent matrices are much easier to successfully complete and to approximate via the Nystr¨om method, as discussed in Section 3. In order to provide some intuition, Cand`es and Recht
(2009) give several classes of randomly generated matrices with low coherence. One such class of matrices is generated from uniform random orthonormal singular vectors and arbitrary singular values. For such a class they show that µ = O(
√log n ·
√4 r**) with high**
probability.1**In what follows, we will show bounds on**
the number of points needed for reconstruction that become more favorable as coherence decreases. However, the bounds are useful for more generous values of coherence than given in the above example. We will also provide an empirical study of coherence for various real-world and synthetic examples.

1For low-rank matrices, √4r **is quite small. Moreover,**
this √4r **factor only appears due to our use of the generally loose inequality** µ 2 ≤
√rµ1, where µ1 **is a slightly**
different notion of coherence used in the original bound in Cand`es and Recht (2009) for this class of matrices.

## 3 Low-Rank, Low-Coherence Bounds

In this section, we make use of coherence to analyze the Nystr¨om method when used with low-rank matrices.

We note that although the bounds presented throughout this section hold for matrices of any rank r**, they**
are only interesting when r = o(
√n**), and hence they**
are most applicable in the "low-rank" setting.

## 3.1 Nystr¨Om Method Bound

The Nystr¨om method is empirically effective in cases where G **has low-rank structure even if the matrix has**
full rank, i.e., G ≈ Gk for some k ≪ n**. Furthermore,**
as stated in Theorem 1 below, when G **is actually a**
low-rank matrix, then the Nystr¨om method can exactly recover the initial matrix (we include the short proof for the sake of completeness).

Theorem 1 ((Kumar et al., 2009b) Thm. 3). Suppose r = rank(G) ≤ k ≤ l and rank(W) = r**. Then the**
Nystr¨om approximation is exact, i.e., kG− GekkF = 0.

$$\left({\bar{5}}\right)$$

Proof. Since G = X⊤X, rank(G) = rank(X) = r.

Similarly, W = X⊤
1 X1 implies rank(X1) = r**, i.e., the**
columns of X1 span the columns of X**. We next let** UX1,k be the k left singular vectors of X1 **associated**
with the top k singular values of X1. We then represent W and C in terms of X1 and X2**, to rewrite the**
Nystr¨om approximation as:

$$\widetilde{G}=CW_{k}^{+}C^{\top}\tag{6}$$ $$=\left[\begin{array}{c}X_{1}^{\top}\\ X_{2}^{\top}\end{array}\right]X_{1}(X_{1}^{\top}X_{1})_{k}^{+}X_{1}^{\top}\left[\begin{array}{cc}X_{1}&X_{2}\end{array}\right]$$ $$=X^{\top}U_{X_{1},k}U_{X_{1},k}^{\top}X.$$

$\boxed{\mathrm{~L~}}$

Furthermore, since columns of X1 **span the columns**
of X, UX1,r is an orthonormal basis for X and I −
UX1,rU
⊤

X1,r **is an orthogonal projection matrix into the**
nullspace of X. Since k ≥ r**, from (6) we have**

$$\|G-\tilde{G}_{k}\|_{F}=\|X^{\top}(I-U_{X_{1},k}U_{X_{1},k}^{\top})X\|_{F}=0.\tag{7}$$

This theorem implies that if G has low-rank, then **there** exists a particular sampling such that rank(W) =
rank(G**) and the Nystr¨om method can perfectly recover the full matrix. However, selecting a suitable**
set of l columns from an n × n **SPSD matrix can be**
an intractable combinatorial problem, and there exist matrices for which the probability of selecting such a subset uniformly at random is exponentially small, e.g., the rank-r **SPSD diagonal matrices discussed earlier. In contrast, a large class of SPSD matrices are**
much more incoherent, and for these matrices, we will