In addition, we can limit branching decisions to a subset of the decisions variables that generates a complete set of assignments. This can significantly reduce the size of the search space. Propagation of the problem and symmetry constraints may prune the search space even further. Running example. *Consider again the problem of finding* normal magic squares. We coded this problem in BProlog on a Pentium 4 3.2 GHz processor with 3GB of memory.

In addition to the problem constraints, we used symmetry breaking constraints that eliminated most of the rotation, *reflection and inversion solution symmetries:*

$$X_{1,1}<\min(X_{1,n},X_{n,1},X_{n,n}),\ X_{1,n}<X_{n,1},$$ $$X_{1,1}\leq n^{2}+1-\max(X_{1,1},X_{1,n},X_{n,1},X_{n,n})\tag{5}$$

We also used symmetry constraints to ensure a simple internal symmetry was within the solution. Even and odd order magic squares often contain different internal symmetries so we used different symmetry constraints for even and odd n. For even n*, we looked for solutions containing* σv ◦ σinv. Recall that this internal symmetry cannot be contained in solutions with odd n *(except* n = 1). For odd n, we looked instead for solutions containing σinv ◦ σ180*. Hence,*
we used the following symmetry constraints for 1 ≤ **i, j** ≤
n:

$$odd(n)\to X_{n+1-j,n+1-i}=n^{2}+1-X_{i,j}$$ $$even(n)\to X_{n+1-i,j}=n^{2}+1-X_{i,j}\tag{6}$$

In the following table, we report backtracks (b) and time
(t) in seconds to find an order n *normal magic square using the default branching heuristic, the problem constraints*
(P*), the symmetry breaking constraints (5) and the internal* symmetry constraints (6).

| n          | P: b/t       | P + 5: b/t   | P + 6: b/t   | P + 5, 6: b/t   |
|------------|--------------|--------------|--------------|-----------------|
| 3          | 2/0.00       | 1/0.00       | 1/0.00       | 1/0.00          |
| 4          | 18/0.00      | 72/0.00      | 13/0.00      | 12/0.00         |
| 5          | 6656/0.13    | 5693/0.12    | 2287/0.03    | 38/0.00         |
| 6          | 4.47 · 109 / | 1.92 · 108 / | 959018/      | 959018/         |
| 2.43 · 105 | 6618.38      | 28.08        | 28.63        |                 |

We see that both symmetry breaking and internal symmetry constraints speed up search. In addition, the combination of the two is usually better than either on their own.

## Van Der Waerden Numbers

We illustrate the use of internal symmetries within solutions with two applications where we have been able to extend the state of the art. In the first, we found new lower bound certificates for Van der Waerden numbers. Such numbers are an important concept in Ramsey theory. In the second application, we increased the size of graceful labellings known for a family of graphs. Graceful labelling has practical applications in areas like communication theory.

The Van der Waerden number, W(**k, l**) is the smallest integer n such that if the integers 1 to n are colored with k colors then there are always at least l integers in arithmetic progression. For instance, W(2, 3) is 9 since the two sets
{1, 4, 5, 8} and {2, 3, 6, 7} contain no arithmetic progression of length 3, but every partitioning of the integers 1 to 9 into two sets contains an arithmetic progression of length 3 or more. The certificate that W(2, 3) > 8 can be represented with the following blocks:
1 2 3 4 5 6 7 8

![0_image_0.png](0_image_0.png)

Finding such certificates can be encoded as a constraint satisfaction problem. To test if W(k, l) > n, we introduce the Boolean variable xi,j where i ∈ [0, k), j ∈ [0, n) and constraints that each integer takes one color (Wi∈[0,k)
xi,j ),
and that no row of colors contains an arithmetic progression of length l (xi,a ∧ . . . ∧ xi,a+d(l−2) → ¬xi,a+d(l−1)). This problem has a number of solution symmetries. For example, we can reverse any certificate and get another symmetric certificate. We can also permute the colors and get another symmetric certificate:
Individual certificates also often contain internal symmetry. For example, the second half of the last certificate repeats the first half:
×2 Hence, this certificate contains the internal symmetry that maps xi,j onto xi,j**+4 mod 8**.

In fact, many known certificates can be generated from some simple symmetry operations on just the colors assigned to the first two or three integers. For instance, the first construction method for Van der Waerden certificates (Rabung 1979) made use of the observation that the largest possible certificates for the known numbers W(**k, l**)
1 consist of a repetition of l −1 times a base pattern. All these certificates, as well as all best lower bounds, have a base pattern of size m = n l−1
. This first method only worked for certificates for which m is prime. An improved construction method (Herwig et al. 2007) generalises it for non-prime m.

An important concept in both construction methods is the primitive root2 of m denoted by r. Let p be the largest prime factor of m, then r is the smallest number for which:
r i**(mod** m) 6= r j(mod m) for 1 ≤ **i < j < q** (7)
We identified four internal symmetries:
σ+m: Apply to all elements xi,j := xi,j + m (mod n)
σ+p: Apply to all elements xi,j := xi,j + p (mod m)
σ×r: Apply to all elements xi,j := xi,j × r (mod m)
σ×r t : At least one subset maps onto itself after applying xi,j := xi,j × r t(mod m) for a t ∈ {1**, . . . , k**}
Consider the largest known certificate for W(5, 3) which has 170 elements. For this certificate, m = 85, p **= 17**, and r = 3. Below the base pattern is shown the first 85 elements.

Notice that for this certificate A, σ+p(A) and σ×r(A) are also certificates. In fact, after sorting the elements and permuting the subsets, this certificate is mapped onto itself after applying these symmetries.

1Except for W(3, 3)
2Our use slightly differs from the conventional definition