
## 18 20 24 26 33 36 38 44 65 66 74 76 79 80 5 13 17 22 30 34 35 37 41 43 50 53 55 61 82 83 6 8 11 12 23 25 28 29 39 47 51 52 54 58 60 67 70 72 78 14 15 31 32 40 42 45 46 56 64 68 69 71 75 77 84 2 4 10 19 21 27 48 49 57 59 62 63 73 81 85 1 3 7 9 16 ⇑ Σ+P 1 3 7 9 16 19 21 27 48 49 57 59 62 63 73 81 85 5 13 17 18 20 24 26 33 36 38 44 65 66 74 76 79 80 6 8 11 12 22 30 34 35 37 41 43 50 53 55 61 82 83 14 15 23 25 28 29 39 47 51 52 54 58 60 67 70 72 78 2 4 10 31 32 40 42 45 46 56 64 68 69 71 75 77 84 ⇓ Σ×R 3 9 21 27 48 57 63 81 59 62 1 7 16 19 49 73 85 15 39 51 54 60 72 78 14 23 29 47 25 28 52 58 67 70 18 24 33 36 66 5 17 20 26 38 44 65 74 80 13 76 79 42 45 69 75 84 2 32 56 68 71 77 4 10 31 40 46 64 6 12 30 8 11 35 41 50 53 83 22 34 37 43 55 61 82

Given these symmetries, we can easily construct a complete certificate. We place the first and last elements (1 and 85) in the first subset and apply σ×r to generate all elements in this subset. We apply σ+p to partition the elements
{1**, . . . ,** 85}. Finally, we obtain a complete certificate by applying σ+m. We generalised this into a construction method.

To find a larger certificate W(**k, l, n**), we test with a constraint solver for increasing n ≡ **0 (mod** l − 1) whether a certificate can be obtained using the following steps:
- break solution symmetry by forcing that the first subset of the partition maps onto itself after applying σ×r t

- choose t ∈ {1, . . . , k}, q ∈ {1**, . . . ,**
m p
}
- place elements q and m in the first subset
- apply the symmetries σ×r t , σ×r, σ+p, and σ+m, to construct a certificate A with n
′
elements
- check with a constraint solver if A lacks an arithmetic progression of length l Using this method we significantly improved some of the best known lower bounds3:
- W(3, 7) > **48811**. The old bound was **43855**.

- W(4, 7) > **420217**. The old bound was **393469**.

## Graceful Graphs

Our second application of internal symmetries is graceful labelling. A graph with e edges is called graceful if its vertices can be labelled with the distinct values {0**, . . . , e**} in such a way that each edge gets a unique label when it is assigned the absolute difference of the vertices it connects. Graceful labelling has a wide range of applications in areas like radio astronomy, cryptography, communication networks and circuit design. Whilst various classes of graphs are known to be graceful (Gallian 1998), there are others where it is not known but is conjectured that they are graceful. One such 3See www.st.ewi.tudelft.nl/sat/˜waerden.php class is the class of double wheel graphs. The graph DWn consists of two cycles of size n and a hub connected all the vertices. The largest double wheel graph that we have seen graceful labelled in the literature4 has size 10.

![0_image_0.png](0_image_0.png)

The problem of finding a graceful labelling can be specified using 2n + 1 variables Xi with domain
{0**, . . . , e**}. This problem has 16n 2solution symmetries (Petrie and Smith 2003):
- Rotation of the vertices (n 2symmetries)
- Inversion of the order of the vertices (4 symmetries)
- Swapping of the inner and outer wheel (2 symmetries)
- Inversion of the labels, Xi**:= 4**n − Xi (2 symmetries)
To identify internal symmetries, we generated all graceful labellings for DW4. This is the smallest double wheel graph with a graceful labelling. We observed two internal symmetries within the 44 solutions of DW4:
σ4n: In 31 solutions, the hub had label 4n or 0 (σinv).

σ+2: If 1 ≤ Xi ≤ n − 2, then Xi+2 := Xi + 2 Although we observed σ+2, we restrict this internal symmetry to 1 ≤ Xi ≤ n − 4 because it proved more effective.

When both symmetries are applied, the computational costs to find a graceful labelling is significantly reduced.

Consider DW24. To construct a graceful labelling, we first assign the hub to value 96 (applying σ4n). Second, we label the first vertex of the outer wheel with 1 and label the first vertex of the inner wheel with 2. Third, we apply symmetry σ+2 to label n-1 vertices with the labels {1**, . . . , n** − 1}.

Finally, we use a constraint solver to label the remaining vertices. Using this method we found the first known graceful labeling for DW24 (see overleaf).

The following table gives the runtime (in seconds) for our constraint solver to find graceful labellings of DWn for the original problem (P) with and without symmetry breaking (SB) constraints (Petrie and Smith 2003). The last column shows the results when we force internal symmetries within solutions. This also breaks the solution symmetries.

n P P + SB P + σ4n, σ+2 4 0.04 0.03 0.03 8 0.24 0.23 0.21 12 20.42 18.34 0.91 16 554.30 259.75 11.31 20 > 7200 **2634**.67 117.08 24 > 7200 > **7200** 602.09 4See www.comp.leeds.ac.uk/bms/Graceful/