

![0_image_0.png](0_image_0.png)

## Related Work

Several forms of symmetry have been identified and exploited in search. For instance, Brown, Finkelstein and Purdom defined symmetry as a permutation of the variables leaving the set of solutions invariant
(Brown, Finkelstein, and Purdom. 1988). This is a subset of the solution symmetries. For the propositional calculus, Krishnamurthy was one of the first to exploit symmetry (Krishnamurthy 1985). He defined symmetry as a permutation of the variables leaving the set of clauses unchanged. Benhamou and Sais extended this to a permutation of the literals preserving the set of clauses
(Benhamou and Sais 1992). Perhaps closest to this work is Puget's symmetry breaking method that considers symmetries which stabilize the current partial set of assignments
(Puget 2003). By comparison, we consider only those symmetries which stabilize a complete set of assignments.

## Conclusions

We have defined the concept of an internal symmetry within a single solution of a constraint satisfaction problem. We compared this with the existing notion of symmetry between different solutions of the same problem. We demonstrated that we can exploit both types of symmetry when solving constraint satisfaction problems. We illustrated the potential of exploiting internal symmetry on two benchmark domains:
Van der Waerden numbers and graceful graphs. By identifying internal symmetries, we were able to extend the state of the art in both cases. With Van der Waerden numbers, we improved two lower bounds by around 10%. With graceful graphs, we more than doubled the size of the largest known double wheel graph with a graceful labelling.

## Acknowledgments

The authors are supported by the Dutch Organization for Scientific Research (NWO) under grant 617.023.611, the Australian Government's Department of Broadband, Communications and the Digital Economy and the ARC.

## References

[Benhamou and Sais 1992] Benhamou, B., and Sais, L.

1992. Theoretical study of symmetries in propositional calculus and applications. In *Proc of CADE-11*, 281–294.

[Brown, Finkelstein, and Purdom. 1988] Brown, C.; Finkelstein, L.; and Purdom, P. 1988. Backtrack searching in the presence of symmetry. In *Proc. of AAECC-6*, 99–110.

[Cohen et al. 2006] Cohen, D.; Jeavons, P.; Jefferson, C.;
Petrie, K.; and Smith, B. 2006. Symmetry definitions for constraint satisfaction problems. *Constraints* 11(2–3):115–
137.

[Crawford et al. 1996] Crawford, J.; Ginsberg, M.; Luks, G.;
and Roy, A. 1996. Symmetry breaking predicates for search problems. In *Proc. of KR '96*, 148–159.

[Flener et al. 2002] Flener, P.; Frisch, A.; Hnich, B.; Kiziltan, Z.; Miguel, I.; Pearson, J.; and Walsh, T. 2002. Breaking row and column symmetry in matrix models. In *Principles and Practice of Constraint Programming (CP 2002*,
462–476.

[Frisch et al. 2002] Frisch, A.; Hnich, B.; Kiziltan, Z.;
Miguel, I.; and Walsh, T. 2002. Global Constraints for Lexicographic Orderings. In *Principles and Practice of Constraint Programming (CP 2002)*, 93–108.

[Gallian 1998] Gallian, J. A. 1998. A dynamic survey of graph labelling. *The Electronic Journal of Combinatorics* 5:
DS6. Updated in 2009.

[Gent and Walsh 1999] Gent, I., and Walsh, T. 1999.

CSPLib: a benchmark library for constraints. Technical report APES-09-1999.

[Herwig et al. 2007] Herwig, P.; Heule, M. J.; van Lambalgen, M.; and van Maaren, H. 2007. A new method to construct lower bounds for Van der Waerden numbers. The Electronic Journal of Combinatorics 14.

[Krishnamurthy 1985] Krishnamurthy, B. 1985. Short proofs for tricky formulas. *Acta Informatica* 22(3):253–275.

[Law et al. 2007] Law, Y.-C.; Lee, J.; Walsh, T.; and Yip, J.

2007. Breaking symmetry of interchangeable variables and values. In *Principles and Practice of Constraint Programming (CP 2007)*, 423–437.

[Petrie and Smith 2003] Petrie, K. E., and Smith, B. M.

2003. Symmetry breaking in graceful graphs. In *Principles* and Practice of Constraint Programming, 930–934.

[Puget 1993] Puget, J.-F. 1993. On the satisfiability of symmetrical constrained satisfaction problems. In *Proc. of ISMIS'93*, 350–361.

[Puget 2003] Puget, J.-F. 2003. Symmetry Breaking Using Stabilizers. In *Principles and Practice of Constraint Programming (CP 2003)*, 585–599.

[Rabung 1979] Rabung, J. R. 1979. Some progression-free partitions constructed using Folkman's method. *Canadian* Mathematical Bulletin 22(1):87–91.

[Walsh 2006a] Walsh, T. 2006. General Symmetry Breaking Constraints. In *Principles and Practice of Constraint* Programming (CP 2006), 650–664.

[Walsh 2006b] Walsh, T. 2006. Symmetry Breaking using Value Precedence. In *Proc. of ECAI-2006*, 168–172.

[Walsh 2007] Walsh, T. 2007. Breaking Value Symmetry.

In *Principles and Practice of Constraint Programming (CP*
2007), 880–887.