# Propagating Conjunctions Of Alldifferent **Constraints** Christian Bessiere Lirmm, Cnrs Montpellier, France Bessiere@Lirmm.Fr George Katsirelos Cril-Cnrs Lens, France Gkatsi@Gmail.Com

Nina Narodytska NICTA and UNSW
Sydney, Australia ninan@cse.unsw.edu.au Claude-Guy Quimper Universite Laval ´
Quebec, Canada ´
cquimper@gmail.com Toby Walsh NICTA and UNSW
Sydney, Australia toby.walsh@nicta.com.au

## Abstract

We study propagation algorithms for the conjunction of two ALLDIFFERENT constraints. Solutions of an ALLDIFFERENT constraint can be seen as perfect matchings on the variable/value bipartite graph. Therefore, we investigate the problem of finding simultaneous bipartite matchings. We present an extension of the famous Hall theorem which characterizes when simultaneous bipartite matchings exists. Unfortunately, finding such matchings is NP-hard in general. However, we prove a surprising result that finding a simultaneous matching on a convex bipartite graph takes just polynomial time. Based on this theoretical result, we provide the first polynomial time bound consistency algorithm for the conjunction of two ALLDIFFERENT constraints. We identify a pathological problem on which this propagator is exponentially faster compared to existing propagators. Our experiments show that this new propagator can offer significant benefits over existing methods.

## Introduction

Global constraints are a critical factor in the success of constraint programming. They capture patterns that often occur in practice (e.g. "these courses must occur at different times"). In addition, fast propagation algorithms are associated with each global constraint to reason about potential solutions (e.g. "these 4 courses have only 3 time slots between them so, by a pigeonhole argument, the problem is infeasible"). One of the oldest and most useful global constraints is the ALLDIFFERENT constraint (Lauriere 1978). This speci- `
fies that a set of variables takes all different values. Many different algorithms have been proposed for propagating the ALLDIFFERENT constraint (Regin 1994; Leconte 1996; ´
Puget 1998). Such propagators can have a significant impact on our ability to solve problems (Stergiou & Walsh 1999).

Problems often contain multiple ALLDIFFERENT constraints (e.g. "The CS courses must occur at different times, as must the IT courses. In addition, CS and IT have several courses in common"). Currently, constraint solvers ignore information about the overlap between multiple constraints
(except for the limited communication provided by the domains of common variables). Here, we show the benefits of reasoning about such overlap. This is a challenging problem Copyright c 2018, Association for the Advancement of Artificial Intelligence (www.aaai.org). All rights reserved.

as finding a solution to just two ALLDIFFERENT constraints is NP-hard (Kutz *et al.* 2008) and existing approaches to deal with such overlaps require exponential space (Lardeux *et al.*
2008). Our approach is to focus on domains that are ordered, as often occurs in practice. For example in our time-tabling problem, values might represent times (which are naturally ordered). In such cases, domains can be compactly represented by intervals. Propagation algorithms can narrow such intervals using the notion of bound consistency. Our main result is to prove we can enforce bound consistency on two ALLDIFFERENT constraints in polynomial time. Our algorithm exploits a connection with matching on bipartite graphs. In particular, we consider *simultaneous* matchings.

By generalizing Hall's theorem, we identify a necessary and sufficient condition for the existence of such a matching and show that the this problem is polynomial for convex graphs.

## Formal Background

Constraint programming. We use capitals for variables and lower case for values. Values range over 1 to d. We write D(X) for the domain of values for X, lb(X) (ub(X))
for the smallest (greatest) value in D(X). A *global constraint* is one in which the number of variables n is a parameter. For instance, ALLDIFFERENT([X1*, . . . , X*n]) ensures that Xi 6= Xj for any *i < j*. Constraint solvers prune search by enforcing properties like domain consistency. A
constraint is *domain consistent* (DC) iff when a variable is assigned any value in its domain, there are compatible values in the domains of all other variables. Such an assignment is a *support*. A constraint is *bound consistent* (BC) iff when a variable is assigned the minimum or maximum value in its domain, there are compatible values between the minimum and maximum domain value for all other variables. Such an assignment is a *bound support*. A constraint is *bound disentailed* iff no possible assignment is a bound support.

Graph Theory. Solutions of ALLDIFFERENT correspond to matchings in a bipartite variable/value graph (Regin 1994). ´
Definition 1. The graph G = hV, Ei is bipartite if V partitions into 2 classes, V = A ∪ B and A ∩ B = ∅*, such that* every edge has ends in different classes.

Definition 2. Let G = hA ∪ B, Ei *be a bipartite graph.*
A matching that covers A *is a set of pairwise non-adjacent* edges M ⊆ E such that every vertex from A *is incident to*